package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  AssessmentName,
  Timestamp,
  UUID,
  AssessmentReportName,
  AssessmentReportDescription,
  Username
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AssessmentReportMetadata(
    id: Option[UUID] = None,
    name: Option[AssessmentReportName] = None,
    description: Option[AssessmentReportDescription] = None,
    assessmentId: Option[UUID] = None,
    assessmentName: Option[AssessmentName] = None,
    author: Option[Username] = None,
    status: Option[zio.aws.auditmanager.model.AssessmentReportStatus] = None,
    creationTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentReportMetadata = {
    import AssessmentReportMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentReportMetadata
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => AssessmentReportName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AssessmentReportDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        assessmentId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.assessmentId)
      .optionallyWith(
        assessmentName.map(value =>
          AssessmentName.unwrap(value): java.lang.String
        )
      )(_.assessmentName)
      .optionallyWith(
        author.map(value => Username.unwrap(value): java.lang.String)
      )(_.author)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentReportMetadata.ReadOnly =
    zio.aws.auditmanager.model.AssessmentReportMetadata.wrap(buildAwsValue())
}
object AssessmentReportMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentReportMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentReportMetadata =
      zio.aws.auditmanager.model.AssessmentReportMetadata(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        assessmentId.map(value => value),
        assessmentName.map(value => value),
        author.map(value => value),
        status.map(value => value),
        creationTime.map(value => value)
      )
    def id: Option[UUID]
    def name: Option[AssessmentReportName]
    def description: Option[AssessmentReportDescription]
    def assessmentId: Option[UUID]
    def assessmentName: Option[AssessmentName]
    def author: Option[Username]
    def status: Option[zio.aws.auditmanager.model.AssessmentReportStatus]
    def creationTime: Option[Timestamp]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, AssessmentReportName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AssessmentReportDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAssessmentId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("assessmentId", assessmentId)
    def getAssessmentName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("assessmentName", assessmentName)
    def getAuthor: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("author", author)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentReportStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReportMetadata
  ) extends zio.aws.auditmanager.model.AssessmentReportMetadata.ReadOnly {
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val name: Option[AssessmentReportName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AssessmentReportName(value)
      )
    override val description: Option[AssessmentReportDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AssessmentReportDescription(value)
      )
    override val assessmentId: Option[UUID] = scala
      .Option(impl.assessmentId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val assessmentName: Option[AssessmentName] = scala
      .Option(impl.assessmentName())
      .map(value => zio.aws.auditmanager.model.primitives.AssessmentName(value))
    override val author: Option[Username] = scala
      .Option(impl.author())
      .map(value => zio.aws.auditmanager.model.primitives.Username(value))
    override val status
        : Option[zio.aws.auditmanager.model.AssessmentReportStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.auditmanager.model.AssessmentReportStatus.wrap(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReportMetadata
  ): zio.aws.auditmanager.model.AssessmentReportMetadata.ReadOnly = new Wrapper(
    impl
  )
}
