package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  Integer,
  UUID,
  ControlDescription,
  ControlName,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class AssessmentControl(
    id: Option[UUID] = None,
    name: Option[ControlName] = None,
    description: Option[ControlDescription] = None,
    status: Option[zio.aws.auditmanager.model.ControlStatus] = None,
    response: Option[zio.aws.auditmanager.model.ControlResponse] = None,
    comments: Option[Iterable[zio.aws.auditmanager.model.ControlComment]] =
      None,
    evidenceSources: Option[Iterable[NonEmptyString]] = None,
    evidenceCount: Option[Integer] = None,
    assessmentReportEvidenceCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentControl = {
    import AssessmentControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentControl
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ControlName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ControlDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(response.map(value => value.unwrap))(_.response)
      .optionallyWith(
        comments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.comments)
      .optionallyWith(
        evidenceSources.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.evidenceSources)
      .optionallyWith(evidenceCount.map(value => value: java.lang.Integer))(
        _.evidenceCount
      )
      .optionallyWith(
        assessmentReportEvidenceCount.map(value => value: java.lang.Integer)
      )(_.assessmentReportEvidenceCount)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentControl.ReadOnly =
    zio.aws.auditmanager.model.AssessmentControl.wrap(buildAwsValue())
}
object AssessmentControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentControl =
      zio.aws.auditmanager.model.AssessmentControl(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        response.map(value => value),
        comments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        evidenceSources.map(value => value),
        evidenceCount.map(value => value),
        assessmentReportEvidenceCount.map(value => value)
      )
    def id: Option[UUID]
    def name: Option[ControlName]
    def description: Option[ControlDescription]
    def status: Option[zio.aws.auditmanager.model.ControlStatus]
    def response: Option[zio.aws.auditmanager.model.ControlResponse]
    def comments
        : Option[List[zio.aws.auditmanager.model.ControlComment.ReadOnly]]
    def evidenceSources: Option[List[NonEmptyString]]
    def evidenceCount: Option[Integer]
    def assessmentReportEvidenceCount: Option[Integer]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ControlName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ControlDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ControlStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResponse
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ControlResponse] =
      AwsError.unwrapOptionField("response", response)
    def getComments: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlComment.ReadOnly
    ]] = AwsError.unwrapOptionField("comments", comments)
    def getEvidenceSources: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("evidenceSources", evidenceSources)
    def getEvidenceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("evidenceCount", evidenceCount)
    def getAssessmentReportEvidenceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "assessmentReportEvidenceCount",
        assessmentReportEvidenceCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentControl
  ) extends zio.aws.auditmanager.model.AssessmentControl.ReadOnly {
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val name: Option[ControlName] = scala
      .Option(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.ControlName(value))
    override val description: Option[ControlDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ControlDescription(value)
      )
    override val status: Option[zio.aws.auditmanager.model.ControlStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.auditmanager.model.ControlStatus.wrap(value))
    override val response: Option[zio.aws.auditmanager.model.ControlResponse] =
      scala
        .Option(impl.response())
        .map(value => zio.aws.auditmanager.model.ControlResponse.wrap(value))
    override val comments
        : Option[List[zio.aws.auditmanager.model.ControlComment.ReadOnly]] =
      scala
        .Option(impl.comments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.ControlComment.wrap(item)
          }.toList
        )
    override val evidenceSources: Option[List[NonEmptyString]] = scala
      .Option(impl.evidenceSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val evidenceCount: Option[Integer] =
      scala.Option(impl.evidenceCount()).map(value => value: Integer)
    override val assessmentReportEvidenceCount: Option[Integer] = scala
      .Option(impl.assessmentReportEvidenceCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentControl
  ): zio.aws.auditmanager.model.AssessmentControl.ReadOnly = new Wrapper(impl)
}
