package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  AccountName,
  EmailAddress,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class AWSAccount(
    id: Option[AccountId] = None,
    emailAddress: Option[EmailAddress] = None,
    name: Option[AccountName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AWSAccount = {
    import AWSAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AWSAccount
      .builder()
      .optionallyWith(
        id.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        name.map(value => AccountName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AWSAccount.ReadOnly =
    zio.aws.auditmanager.model.AWSAccount.wrap(buildAwsValue())
}
object AWSAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AWSAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AWSAccount =
      zio.aws.auditmanager.model.AWSAccount(
        id.map(value => value),
        emailAddress.map(value => value),
        name.map(value => value)
      )
    def id: Option[AccountId]
    def emailAddress: Option[EmailAddress]
    def name: Option[AccountName]
    def getId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("id", id)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getName: ZIO[Any, AwsError, AccountName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AWSAccount
  ) extends zio.aws.auditmanager.model.AWSAccount.ReadOnly {
    override val id: Option[AccountId] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val emailAddress: Option[EmailAddress] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.auditmanager.model.primitives.EmailAddress(value))
    override val name: Option[AccountName] = scala
      .Option(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.AccountName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AWSAccount
  ): zio.aws.auditmanager.model.AWSAccount.ReadOnly = new Wrapper(impl)
}
