package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateControlResponse(
    control: Option[zio.aws.auditmanager.model.Control] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateControlResponse = {
    import UpdateControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateControlResponse
      .builder()
      .optionallyWith(control.map(value => value.buildAwsValue()))(_.control)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.UpdateControlResponse.ReadOnly =
    zio.aws.auditmanager.model.UpdateControlResponse.wrap(buildAwsValue())
}
object UpdateControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateControlResponse =
      zio.aws.auditmanager.model
        .UpdateControlResponse(control.map(value => value.asEditable))
    def control: Option[zio.aws.auditmanager.model.Control.ReadOnly]
    def getControl
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Control.ReadOnly] =
      AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateControlResponse
  ) extends zio.aws.auditmanager.model.UpdateControlResponse.ReadOnly {
    override val control: Option[zio.aws.auditmanager.model.Control.ReadOnly] =
      scala
        .Option(impl.control())
        .map(value => zio.aws.auditmanager.model.Control.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateControlResponse
  ): zio.aws.auditmanager.model.UpdateControlResponse.ReadOnly = new Wrapper(
    impl
  )
}
