package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.{TagKey, AuditManagerArn}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: AuditManagerArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest
      .builder()
      .resourceArn(AuditManagerArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.UntagResourceRequest.ReadOnly =
    zio.aws.auditmanager.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UntagResourceRequest =
      zio.aws.auditmanager.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: AuditManagerArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, AuditManagerArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest
  ) extends zio.aws.auditmanager.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: AuditManagerArn =
      zio.aws.auditmanager.model.primitives.AuditManagerArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.auditmanager.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest
  ): zio.aws.auditmanager.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
