package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.SourceType
  ): zio.aws.auditmanager.model.SourceType = value match {
    case software.amazon.awssdk.services.auditmanager.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceType.AWS_CLOUDTRAIL =>
      val r = AWS_Cloudtrail
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceType.AWS_CONFIG =>
      val r = AWS_Config
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceType.AWS_SECURITY_HUB =>
      val r = AWS_Security_Hub
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceType.AWS_API_CALL =>
      val r = AWS_API_Call
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceType.MANUAL =>
      val r = MANUAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceType =
      software.amazon.awssdk.services.auditmanager.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_Cloudtrail extends zio.aws.auditmanager.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceType =
      software.amazon.awssdk.services.auditmanager.model.SourceType.AWS_CLOUDTRAIL
  }
  case object AWS_Config extends zio.aws.auditmanager.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceType =
      software.amazon.awssdk.services.auditmanager.model.SourceType.AWS_CONFIG
  }
  case object AWS_Security_Hub extends zio.aws.auditmanager.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceType =
      software.amazon.awssdk.services.auditmanager.model.SourceType.AWS_SECURITY_HUB
  }
  case object AWS_API_Call extends zio.aws.auditmanager.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceType =
      software.amazon.awssdk.services.auditmanager.model.SourceType.AWS_API_CALL
  }
  case object MANUAL extends zio.aws.auditmanager.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceType =
      software.amazon.awssdk.services.auditmanager.model.SourceType.MANUAL
  }
}
