package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.KeywordValue
import scala.jdk.CollectionConverters.*
final case class SourceKeyword(
    keywordInputType: Option[zio.aws.auditmanager.model.KeywordInputType] =
      None,
    keywordValue: Option[KeywordValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.SourceKeyword = {
    import SourceKeyword.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.SourceKeyword
      .builder()
      .optionallyWith(keywordInputType.map(value => value.unwrap))(
        _.keywordInputType
      )
      .optionallyWith(
        keywordValue.map(value => KeywordValue.unwrap(value): java.lang.String)
      )(_.keywordValue)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.SourceKeyword.ReadOnly =
    zio.aws.auditmanager.model.SourceKeyword.wrap(buildAwsValue())
}
object SourceKeyword {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.SourceKeyword
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.SourceKeyword =
      zio.aws.auditmanager.model.SourceKeyword(
        keywordInputType.map(value => value),
        keywordValue.map(value => value)
      )
    def keywordInputType: Option[zio.aws.auditmanager.model.KeywordInputType]
    def keywordValue: Option[KeywordValue]
    def getKeywordInputType
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.KeywordInputType] =
      AwsError.unwrapOptionField("keywordInputType", keywordInputType)
    def getKeywordValue: ZIO[Any, AwsError, KeywordValue] =
      AwsError.unwrapOptionField("keywordValue", keywordValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.SourceKeyword
  ) extends zio.aws.auditmanager.model.SourceKeyword.ReadOnly {
    override val keywordInputType
        : Option[zio.aws.auditmanager.model.KeywordInputType] = scala
      .Option(impl.keywordInputType())
      .map(value => zio.aws.auditmanager.model.KeywordInputType.wrap(value))
    override val keywordValue: Option[KeywordValue] = scala
      .Option(impl.keywordValue())
      .map(value => zio.aws.auditmanager.model.primitives.KeywordValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.SourceKeyword
  ): zio.aws.auditmanager.model.SourceKeyword.ReadOnly = new Wrapper(impl)
}
