package zio.aws.auditmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{MaxResults, Token}
import scala.jdk.CollectionConverters.*
final case class ListAssessmentFrameworkShareRequestsRequest(
    requestType: zio.aws.auditmanager.model.ShareRequestType,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest = {
    import ListAssessmentFrameworkShareRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest
      .builder()
      .requestType(requestType.unwrap)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest
      .wrap(buildAwsValue())
}
object ListAssessmentFrameworkShareRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest =
      zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest(
        requestType,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def requestType: zio.aws.auditmanager.model.ShareRequestType
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getRequestType
        : ZIO[Any, Nothing, zio.aws.auditmanager.model.ShareRequestType] =
      ZIO.succeed(requestType)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest
  ) extends zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest.ReadOnly {
    override val requestType: zio.aws.auditmanager.model.ShareRequestType =
      zio.aws.auditmanager.model.ShareRequestType.wrap(impl.requestType())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest
  ): zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest.ReadOnly =
    new Wrapper(impl)
}
