package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSettingsRequest(
    attribute: zio.aws.auditmanager.model.SettingAttribute
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest = {
    import GetSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest
      .builder()
      .attribute(attribute.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetSettingsRequest.ReadOnly =
    zio.aws.auditmanager.model.GetSettingsRequest.wrap(buildAwsValue())
}
object GetSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetSettingsRequest =
      zio.aws.auditmanager.model.GetSettingsRequest(attribute)
    def attribute: zio.aws.auditmanager.model.SettingAttribute
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.auditmanager.model.SettingAttribute] =
      ZIO.succeed(attribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest
  ) extends zio.aws.auditmanager.model.GetSettingsRequest.ReadOnly {
    override val attribute: zio.aws.auditmanager.model.SettingAttribute =
      zio.aws.auditmanager.model.SettingAttribute.wrap(impl.attribute())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest
  ): zio.aws.auditmanager.model.GetSettingsRequest.ReadOnly = new Wrapper(impl)
}
