package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateAssessmentReportResponse(
    assessmentReport: Option[zio.aws.auditmanager.model.AssessmentReport] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportResponse = {
    import CreateAssessmentReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportResponse
      .builder()
      .optionallyWith(assessmentReport.map(value => value.buildAwsValue()))(
        _.assessmentReport
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.CreateAssessmentReportResponse.ReadOnly =
    zio.aws.auditmanager.model.CreateAssessmentReportResponse
      .wrap(buildAwsValue())
}
object CreateAssessmentReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.CreateAssessmentReportResponse =
      zio.aws.auditmanager.model.CreateAssessmentReportResponse(
        assessmentReport.map(value => value.asEditable)
      )
    def assessmentReport
        : Option[zio.aws.auditmanager.model.AssessmentReport.ReadOnly]
    def getAssessmentReport: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentReport.ReadOnly
    ] = AwsError.unwrapOptionField("assessmentReport", assessmentReport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportResponse
  ) extends zio.aws.auditmanager.model.CreateAssessmentReportResponse.ReadOnly {
    override val assessmentReport
        : Option[zio.aws.auditmanager.model.AssessmentReport.ReadOnly] = scala
      .Option(impl.assessmentReport())
      .map(value => zio.aws.auditmanager.model.AssessmentReport.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportResponse
  ): zio.aws.auditmanager.model.CreateAssessmentReportResponse.ReadOnly =
    new Wrapper(impl)
}
