package zio.aws.auditmanager
import zio.aws.auditmanager.model.GetAssessmentResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.auditmanager.model.{
  GetDelegationsRequest,
  DeleteControlRequest,
  GetAccountStatusRequest,
  BatchCreateDelegationByAssessmentRequest,
  BatchAssociateAssessmentReportEvidenceRequest,
  GetInsightsByAssessmentRequest,
  DeleteAssessmentReportRequest,
  UpdateSettingsRequest,
  CreateControlRequest,
  BatchDisassociateAssessmentReportEvidenceRequest,
  GetOrganizationAdminAccountRequest,
  ListKeywordsForDataSourceRequest,
  UpdateAssessmentControlSetStatusRequest,
  RegisterOrganizationAdminAccountRequest,
  GetAssessmentRequest,
  GetInsightsRequest,
  GetEvidenceByEvidenceFolderRequest,
  ListNotificationsRequest,
  GetServicesInScopeRequest,
  ListTagsForResourceRequest,
  RegisterAccountRequest,
  UpdateAssessmentFrameworkRequest,
  ListAssessmentsRequest,
  GetEvidenceRequest,
  UpdateAssessmentStatusRequest,
  ListControlInsightsByControlDomainRequest,
  GetChangeLogsRequest,
  UpdateAssessmentRequest,
  DeleteAssessmentRequest,
  CreateAssessmentFrameworkRequest,
  GetSettingsRequest,
  ListControlDomainInsightsByAssessmentRequest,
  ListControlsRequest,
  CreateAssessmentReportRequest,
  GetAssessmentFrameworkRequest,
  ListAssessmentControlInsightsByControlDomainRequest,
  ListAssessmentFrameworksRequest,
  GetControlRequest,
  CreateAssessmentRequest,
  GetEvidenceFoldersByAssessmentRequest,
  ListControlDomainInsightsRequest,
  UntagResourceRequest,
  ListAssessmentFrameworkShareRequestsRequest,
  DeregisterAccountRequest,
  GetEvidenceFolderRequest,
  UpdateControlRequest,
  BatchImportEvidenceToAssessmentControlRequest,
  BatchDeleteDelegationByAssessmentRequest,
  StartAssessmentFrameworkShareRequest,
  ValidateAssessmentReportIntegrityRequest,
  UpdateAssessmentControlRequest,
  AssociateAssessmentReportEvidenceFolderRequest,
  DeleteAssessmentFrameworkShareRequest,
  GetAssessmentReportUrlRequest,
  DeregisterOrganizationAdminAccountRequest,
  DeleteAssessmentFrameworkRequest,
  ListAssessmentReportsRequest,
  GetEvidenceFoldersByAssessmentControlRequest,
  TagResourceRequest,
  UpdateAssessmentFrameworkShareRequest,
  DisassociateAssessmentReportEvidenceFolderRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient
object AuditManagerMock extends Mock[AuditManager] {
  object ListKeywordsForDataSource
      extends Effect[
        ListKeywordsForDataSourceRequest,
        AwsError,
        zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly
      ]
  object UpdateAssessmentStatus
      extends Effect[
        UpdateAssessmentStatusRequest,
        AwsError,
        zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly
      ]
  object BatchDisassociateAssessmentReportEvidence
      extends Effect[
        BatchDisassociateAssessmentReportEvidenceRequest,
        AwsError,
        zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse.ReadOnly
      ]
  object BatchCreateDelegationByAssessment
      extends Effect[
        BatchCreateDelegationByAssessmentRequest,
        AwsError,
        zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly
      ]
  object CreateControl
      extends Effect[
        CreateControlRequest,
        AwsError,
        zio.aws.auditmanager.model.CreateControlResponse.ReadOnly
      ]
  object CreateAssessment
      extends Effect[
        CreateAssessmentRequest,
        AwsError,
        zio.aws.auditmanager.model.CreateAssessmentResponse.ReadOnly
      ]
  object GetSettings
      extends Effect[
        GetSettingsRequest,
        AwsError,
        zio.aws.auditmanager.model.GetSettingsResponse.ReadOnly
      ]
  object ListControls
      extends Effect[
        ListControlsRequest,
        AwsError,
        zio.aws.auditmanager.model.ListControlsResponse.ReadOnly
      ]
  object ListControlInsightsByControlDomain
      extends Effect[
        ListControlInsightsByControlDomainRequest,
        AwsError,
        zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse.ReadOnly
      ]
  object GetInsights
      extends Effect[
        GetInsightsRequest,
        AwsError,
        zio.aws.auditmanager.model.GetInsightsResponse.ReadOnly
      ]
  object RegisterAccount
      extends Effect[
        RegisterAccountRequest,
        AwsError,
        zio.aws.auditmanager.model.RegisterAccountResponse.ReadOnly
      ]
  object GetAssessmentReportUrl
      extends Effect[
        GetAssessmentReportUrlRequest,
        AwsError,
        zio.aws.auditmanager.model.GetAssessmentReportUrlResponse.ReadOnly
      ]
  object ListNotifications
      extends Effect[
        ListNotificationsRequest,
        AwsError,
        zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly
      ]
  object GetServicesInScope
      extends Effect[
        GetServicesInScopeRequest,
        AwsError,
        zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly
      ]
  object ListControlDomainInsightsByAssessment
      extends Effect[
        ListControlDomainInsightsByAssessmentRequest,
        AwsError,
        zio.aws.auditmanager.model.ListControlDomainInsightsByAssessmentResponse.ReadOnly
      ]
  object GetAccountStatus
      extends Effect[
        GetAccountStatusRequest,
        AwsError,
        zio.aws.auditmanager.model.GetAccountStatusResponse.ReadOnly
      ]
  object UpdateAssessment
      extends Effect[
        UpdateAssessmentRequest,
        AwsError,
        zio.aws.auditmanager.model.UpdateAssessmentResponse.ReadOnly
      ]
  object BatchImportEvidenceToAssessmentControl
      extends Effect[
        BatchImportEvidenceToAssessmentControlRequest,
        AwsError,
        zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse.ReadOnly
      ]
  object GetEvidence
      extends Effect[
        GetEvidenceRequest,
        AwsError,
        zio.aws.auditmanager.model.GetEvidenceResponse.ReadOnly
      ]
  object UpdateAssessmentControlSetStatus
      extends Effect[
        UpdateAssessmentControlSetStatusRequest,
        AwsError,
        zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse.ReadOnly
      ]
  object GetAssessmentFramework
      extends Effect[
        GetAssessmentFrameworkRequest,
        AwsError,
        zio.aws.auditmanager.model.GetAssessmentFrameworkResponse.ReadOnly
      ]
  object DeleteAssessmentFramework
      extends Effect[
        DeleteAssessmentFrameworkRequest,
        AwsError,
        zio.aws.auditmanager.model.DeleteAssessmentFrameworkResponse.ReadOnly
      ]
  object ListAssessmentFrameworks
      extends Effect[
        ListAssessmentFrameworksRequest,
        AwsError,
        zio.aws.auditmanager.model.ListAssessmentFrameworksResponse.ReadOnly
      ]
  object DeleteControl
      extends Effect[
        DeleteControlRequest,
        AwsError,
        zio.aws.auditmanager.model.DeleteControlResponse.ReadOnly
      ]
  object GetChangeLogs
      extends Effect[
        GetChangeLogsRequest,
        AwsError,
        zio.aws.auditmanager.model.GetChangeLogsResponse.ReadOnly
      ]
  object UpdateControl
      extends Effect[
        UpdateControlRequest,
        AwsError,
        zio.aws.auditmanager.model.UpdateControlResponse.ReadOnly
      ]
  object GetControl
      extends Effect[
        GetControlRequest,
        AwsError,
        zio.aws.auditmanager.model.GetControlResponse.ReadOnly
      ]
  object ValidateAssessmentReportIntegrity
      extends Effect[
        ValidateAssessmentReportIntegrityRequest,
        AwsError,
        zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse.ReadOnly
      ]
  object DisassociateAssessmentReportEvidenceFolder
      extends Effect[
        DisassociateAssessmentReportEvidenceFolderRequest,
        AwsError,
        zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse.ReadOnly
      ]
  object UpdateAssessmentFramework
      extends Effect[
        UpdateAssessmentFrameworkRequest,
        AwsError,
        zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse.ReadOnly
      ]
  object GetDelegations
      extends Effect[
        GetDelegationsRequest,
        AwsError,
        zio.aws.auditmanager.model.GetDelegationsResponse.ReadOnly
      ]
  object GetEvidenceByEvidenceFolder
      extends Effect[
        GetEvidenceByEvidenceFolderRequest,
        AwsError,
        zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.auditmanager.model.UntagResourceResponse.ReadOnly
      ]
  object UpdateSettings
      extends Effect[
        UpdateSettingsRequest,
        AwsError,
        zio.aws.auditmanager.model.UpdateSettingsResponse.ReadOnly
      ]
  object DeleteAssessmentReport
      extends Effect[
        DeleteAssessmentReportRequest,
        AwsError,
        zio.aws.auditmanager.model.DeleteAssessmentReportResponse.ReadOnly
      ]
  object GetEvidenceFolder
      extends Effect[
        GetEvidenceFolderRequest,
        AwsError,
        zio.aws.auditmanager.model.GetEvidenceFolderResponse.ReadOnly
      ]
  object GetAssessment extends Effect[GetAssessmentRequest, AwsError, ReadOnly]
  object StartAssessmentFrameworkShare
      extends Effect[
        StartAssessmentFrameworkShareRequest,
        AwsError,
        zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse.ReadOnly
      ]
  object CreateAssessmentReport
      extends Effect[
        CreateAssessmentReportRequest,
        AwsError,
        zio.aws.auditmanager.model.CreateAssessmentReportResponse.ReadOnly
      ]
  object GetInsightsByAssessment
      extends Effect[
        GetInsightsByAssessmentRequest,
        AwsError,
        zio.aws.auditmanager.model.GetInsightsByAssessmentResponse.ReadOnly
      ]
  object UpdateAssessmentControl
      extends Effect[
        UpdateAssessmentControlRequest,
        AwsError,
        zio.aws.auditmanager.model.UpdateAssessmentControlResponse.ReadOnly
      ]
  object AssociateAssessmentReportEvidenceFolder
      extends Effect[
        AssociateAssessmentReportEvidenceFolderRequest,
        AwsError,
        zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.auditmanager.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CreateAssessmentFramework
      extends Effect[
        CreateAssessmentFrameworkRequest,
        AwsError,
        zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse.ReadOnly
      ]
  object DeleteAssessmentFrameworkShare
      extends Effect[
        DeleteAssessmentFrameworkShareRequest,
        AwsError,
        zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.auditmanager.model.TagResourceResponse.ReadOnly
      ]
  object DeregisterOrganizationAdminAccount
      extends Effect[
        DeregisterOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountResponse.ReadOnly
      ]
  object BatchAssociateAssessmentReportEvidence
      extends Effect[
        BatchAssociateAssessmentReportEvidenceRequest,
        AwsError,
        zio.aws.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse.ReadOnly
      ]
  object GetEvidenceFoldersByAssessmentControl
      extends Effect[
        GetEvidenceFoldersByAssessmentControlRequest,
        AwsError,
        zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse.ReadOnly
      ]
  object DeregisterAccount
      extends Effect[
        DeregisterAccountRequest,
        AwsError,
        zio.aws.auditmanager.model.DeregisterAccountResponse.ReadOnly
      ]
  object ListAssessmentReports
      extends Effect[
        ListAssessmentReportsRequest,
        AwsError,
        zio.aws.auditmanager.model.ListAssessmentReportsResponse.ReadOnly
      ]
  object GetOrganizationAdminAccount
      extends Effect[
        GetOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse.ReadOnly
      ]
  object BatchDeleteDelegationByAssessment
      extends Effect[
        BatchDeleteDelegationByAssessmentRequest,
        AwsError,
        zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse.ReadOnly
      ]
  object DeleteAssessment
      extends Effect[
        DeleteAssessmentRequest,
        AwsError,
        zio.aws.auditmanager.model.DeleteAssessmentResponse.ReadOnly
      ]
  object ListAssessmentControlInsightsByControlDomain
      extends Effect[
        ListAssessmentControlInsightsByControlDomainRequest,
        AwsError,
        zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly
      ]
  object GetEvidenceFoldersByAssessment
      extends Effect[
        GetEvidenceFoldersByAssessmentRequest,
        AwsError,
        zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse.ReadOnly
      ]
  object RegisterOrganizationAdminAccount
      extends Effect[
        RegisterOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.auditmanager.model.RegisterOrganizationAdminAccountResponse.ReadOnly
      ]
  object ListAssessments
      extends Effect[
        ListAssessmentsRequest,
        AwsError,
        zio.aws.auditmanager.model.ListAssessmentsResponse.ReadOnly
      ]
  object UpdateAssessmentFrameworkShare
      extends Effect[
        UpdateAssessmentFrameworkShareRequest,
        AwsError,
        zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse.ReadOnly
      ]
  object ListControlDomainInsights
      extends Effect[
        ListControlDomainInsightsRequest,
        AwsError,
        zio.aws.auditmanager.model.ListControlDomainInsightsResponse.ReadOnly
      ]
  object ListAssessmentFrameworkShareRequests
      extends Effect[
        ListAssessmentFrameworkShareRequestsRequest,
        AwsError,
        zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AuditManager] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new AuditManager {
          val api: AuditManagerAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : AuditManager = this
          def listKeywordsForDataSource(
              request: ListKeywordsForDataSourceRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly
          ] = proxy(ListKeywordsForDataSource, request)
          def updateAssessmentStatus(
              request: UpdateAssessmentStatusRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly
          ] = proxy(UpdateAssessmentStatus, request)
          def batchDisassociateAssessmentReportEvidence(
              request: BatchDisassociateAssessmentReportEvidenceRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse.ReadOnly
          ] = proxy(BatchDisassociateAssessmentReportEvidence, request)
          def batchCreateDelegationByAssessment(
              request: BatchCreateDelegationByAssessmentRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly
          ] = proxy(BatchCreateDelegationByAssessment, request)
          def createControl(request: CreateControlRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.CreateControlResponse.ReadOnly
          ] = proxy(CreateControl, request)
          def createAssessment(request: CreateAssessmentRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.CreateAssessmentResponse.ReadOnly
          ] = proxy(CreateAssessment, request)
          def getSettings(request: GetSettingsRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.GetSettingsResponse.ReadOnly
          ] = proxy(GetSettings, request)
          def listControls(request: ListControlsRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.ListControlsResponse.ReadOnly
          ] = proxy(ListControls, request)
          def listControlInsightsByControlDomain(
              request: ListControlInsightsByControlDomainRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse.ReadOnly
          ] = proxy(ListControlInsightsByControlDomain, request)
          def getInsights(request: GetInsightsRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.GetInsightsResponse.ReadOnly
          ] = proxy(GetInsights, request)
          def registerAccount(request: RegisterAccountRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.RegisterAccountResponse.ReadOnly
          ] = proxy(RegisterAccount, request)
          def getAssessmentReportUrl(
              request: GetAssessmentReportUrlRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.GetAssessmentReportUrlResponse.ReadOnly
          ] = proxy(GetAssessmentReportUrl, request)
          def listNotifications(request: ListNotificationsRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly
          ] = proxy(ListNotifications, request)
          def getServicesInScope(request: GetServicesInScopeRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly
          ] = proxy(GetServicesInScope, request)
          def listControlDomainInsightsByAssessment(
              request: ListControlDomainInsightsByAssessmentRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.ListControlDomainInsightsByAssessmentResponse.ReadOnly
          ] = proxy(ListControlDomainInsightsByAssessment, request)
          def getAccountStatus(request: GetAccountStatusRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.GetAccountStatusResponse.ReadOnly
          ] = proxy(GetAccountStatus, request)
          def updateAssessment(request: UpdateAssessmentRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.UpdateAssessmentResponse.ReadOnly
          ] = proxy(UpdateAssessment, request)
          def batchImportEvidenceToAssessmentControl(
              request: BatchImportEvidenceToAssessmentControlRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse.ReadOnly
          ] = proxy(BatchImportEvidenceToAssessmentControl, request)
          def getEvidence(request: GetEvidenceRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.GetEvidenceResponse.ReadOnly
          ] = proxy(GetEvidence, request)
          def updateAssessmentControlSetStatus(
              request: UpdateAssessmentControlSetStatusRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse.ReadOnly
          ] = proxy(UpdateAssessmentControlSetStatus, request)
          def getAssessmentFramework(
              request: GetAssessmentFrameworkRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.GetAssessmentFrameworkResponse.ReadOnly
          ] = proxy(GetAssessmentFramework, request)
          def deleteAssessmentFramework(
              request: DeleteAssessmentFrameworkRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.DeleteAssessmentFrameworkResponse.ReadOnly
          ] = proxy(DeleteAssessmentFramework, request)
          def listAssessmentFrameworks(
              request: ListAssessmentFrameworksRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.ListAssessmentFrameworksResponse.ReadOnly
          ] = proxy(ListAssessmentFrameworks, request)
          def deleteControl(request: DeleteControlRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.DeleteControlResponse.ReadOnly
          ] = proxy(DeleteControl, request)
          def getChangeLogs(request: GetChangeLogsRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.GetChangeLogsResponse.ReadOnly
          ] = proxy(GetChangeLogs, request)
          def updateControl(request: UpdateControlRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.UpdateControlResponse.ReadOnly
          ] = proxy(UpdateControl, request)
          def getControl(request: GetControlRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.GetControlResponse.ReadOnly
          ] = proxy(GetControl, request)
          def validateAssessmentReportIntegrity(
              request: ValidateAssessmentReportIntegrityRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse.ReadOnly
          ] = proxy(ValidateAssessmentReportIntegrity, request)
          def disassociateAssessmentReportEvidenceFolder(
              request: DisassociateAssessmentReportEvidenceFolderRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse.ReadOnly
          ] = proxy(DisassociateAssessmentReportEvidenceFolder, request)
          def updateAssessmentFramework(
              request: UpdateAssessmentFrameworkRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse.ReadOnly
          ] = proxy(UpdateAssessmentFramework, request)
          def getDelegations(request: GetDelegationsRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.GetDelegationsResponse.ReadOnly
          ] = proxy(GetDelegations, request)
          def getEvidenceByEvidenceFolder(
              request: GetEvidenceByEvidenceFolderRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly
          ] = proxy(GetEvidenceByEvidenceFolder, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def updateSettings(request: UpdateSettingsRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.UpdateSettingsResponse.ReadOnly
          ] = proxy(UpdateSettings, request)
          def deleteAssessmentReport(
              request: DeleteAssessmentReportRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.DeleteAssessmentReportResponse.ReadOnly
          ] = proxy(DeleteAssessmentReport, request)
          def getEvidenceFolder(request: GetEvidenceFolderRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.GetEvidenceFolderResponse.ReadOnly
          ] = proxy(GetEvidenceFolder, request)
          def getAssessment(
              request: GetAssessmentRequest
          ): IO[AwsError, ReadOnly] = proxy(GetAssessment, request)
          def startAssessmentFrameworkShare(
              request: StartAssessmentFrameworkShareRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse.ReadOnly
          ] = proxy(StartAssessmentFrameworkShare, request)
          def createAssessmentReport(
              request: CreateAssessmentReportRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.CreateAssessmentReportResponse.ReadOnly
          ] = proxy(CreateAssessmentReport, request)
          def getInsightsByAssessment(
              request: GetInsightsByAssessmentRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.GetInsightsByAssessmentResponse.ReadOnly
          ] = proxy(GetInsightsByAssessment, request)
          def updateAssessmentControl(
              request: UpdateAssessmentControlRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.UpdateAssessmentControlResponse.ReadOnly
          ] = proxy(UpdateAssessmentControl, request)
          def associateAssessmentReportEvidenceFolder(
              request: AssociateAssessmentReportEvidenceFolderRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse.ReadOnly
          ] = proxy(AssociateAssessmentReportEvidenceFolder, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def createAssessmentFramework(
              request: CreateAssessmentFrameworkRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse.ReadOnly
          ] = proxy(CreateAssessmentFramework, request)
          def deleteAssessmentFrameworkShare(
              request: DeleteAssessmentFrameworkShareRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareResponse.ReadOnly
          ] = proxy(DeleteAssessmentFrameworkShare, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def deregisterOrganizationAdminAccount(
              request: DeregisterOrganizationAdminAccountRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountResponse.ReadOnly
          ] = proxy(DeregisterOrganizationAdminAccount, request)
          def batchAssociateAssessmentReportEvidence(
              request: BatchAssociateAssessmentReportEvidenceRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse.ReadOnly
          ] = proxy(BatchAssociateAssessmentReportEvidence, request)
          def getEvidenceFoldersByAssessmentControl(
              request: GetEvidenceFoldersByAssessmentControlRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse.ReadOnly
          ] = proxy(GetEvidenceFoldersByAssessmentControl, request)
          def deregisterAccount(request: DeregisterAccountRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.DeregisterAccountResponse.ReadOnly
          ] = proxy(DeregisterAccount, request)
          def listAssessmentReports(request: ListAssessmentReportsRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.ListAssessmentReportsResponse.ReadOnly
          ] = proxy(ListAssessmentReports, request)
          def getOrganizationAdminAccount(
              request: GetOrganizationAdminAccountRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse.ReadOnly
          ] = proxy(GetOrganizationAdminAccount, request)
          def batchDeleteDelegationByAssessment(
              request: BatchDeleteDelegationByAssessmentRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse.ReadOnly
          ] = proxy(BatchDeleteDelegationByAssessment, request)
          def deleteAssessment(request: DeleteAssessmentRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.DeleteAssessmentResponse.ReadOnly
          ] = proxy(DeleteAssessment, request)
          def listAssessmentControlInsightsByControlDomain(
              request: ListAssessmentControlInsightsByControlDomainRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly
          ] = proxy(ListAssessmentControlInsightsByControlDomain, request)
          def getEvidenceFoldersByAssessment(
              request: GetEvidenceFoldersByAssessmentRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse.ReadOnly
          ] = proxy(GetEvidenceFoldersByAssessment, request)
          def registerOrganizationAdminAccount(
              request: RegisterOrganizationAdminAccountRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.RegisterOrganizationAdminAccountResponse.ReadOnly
          ] = proxy(RegisterOrganizationAdminAccount, request)
          def listAssessments(request: ListAssessmentsRequest): IO[
            AwsError,
            zio.aws.auditmanager.model.ListAssessmentsResponse.ReadOnly
          ] = proxy(ListAssessments, request)
          def updateAssessmentFrameworkShare(
              request: UpdateAssessmentFrameworkShareRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse.ReadOnly
          ] = proxy(UpdateAssessmentFrameworkShare, request)
          def listControlDomainInsights(
              request: ListControlDomainInsightsRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.ListControlDomainInsightsResponse.ReadOnly
          ] = proxy(ListControlDomainInsights, request)
          def listAssessmentFrameworkShareRequests(
              request: ListAssessmentFrameworkShareRequestsRequest
          ): IO[
            AwsError,
            zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly
          ] = proxy(ListAssessmentFrameworkShareRequests, request)
        }
      }
    }
    .toLayer
}
