package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{KmsKey, SNSTopic}
import scala.jdk.CollectionConverters.*
final case class Settings(
    isAwsOrgEnabled: Option[Boolean] = None,
    snsTopic: Option[SNSTopic] = None,
    defaultAssessmentReportsDestination: Option[
      zio.aws.auditmanager.model.AssessmentReportsDestination
    ] = None,
    defaultProcessOwners: Option[Iterable[zio.aws.auditmanager.model.Role]] =
      None,
    kmsKey: Option[KmsKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Settings = {
    import Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Settings
      .builder()
      .optionallyWith(isAwsOrgEnabled.map(value => value: java.lang.Boolean))(
        _.isAwsOrgEnabled
      )
      .optionallyWith(
        snsTopic.map(value => SNSTopic.unwrap(value): java.lang.String)
      )(_.snsTopic)
      .optionallyWith(
        defaultAssessmentReportsDestination.map(value => value.buildAwsValue())
      )(_.defaultAssessmentReportsDestination)
      .optionallyWith(
        defaultProcessOwners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultProcessOwners)
      .optionallyWith(
        kmsKey.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Settings.ReadOnly =
    zio.aws.auditmanager.model.Settings.wrap(buildAwsValue())
}
object Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Settings =
      zio.aws.auditmanager.model.Settings(
        isAwsOrgEnabled.map(value => value),
        snsTopic.map(value => value),
        defaultAssessmentReportsDestination.map(value => value.asEditable),
        defaultProcessOwners.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKey.map(value => value)
      )
    def isAwsOrgEnabled: Option[Boolean]
    def snsTopic: Option[SNSTopic]
    def defaultAssessmentReportsDestination: Option[
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ]
    def defaultProcessOwners
        : Option[List[zio.aws.auditmanager.model.Role.ReadOnly]]
    def kmsKey: Option[KmsKey]
    def getIsAwsOrgEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAwsOrgEnabled", isAwsOrgEnabled)
    def getSnsTopic: ZIO[Any, AwsError, SNSTopic] =
      AwsError.unwrapOptionField("snsTopic", snsTopic)
    def getDefaultAssessmentReportsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultAssessmentReportsDestination",
      defaultAssessmentReportsDestination
    )
    def getDefaultProcessOwners
        : ZIO[Any, AwsError, List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      AwsError.unwrapOptionField("defaultProcessOwners", defaultProcessOwners)
    def getKmsKey: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Settings
  ) extends zio.aws.auditmanager.model.Settings.ReadOnly {
    override val isAwsOrgEnabled: Option[Boolean] =
      scala.Option(impl.isAwsOrgEnabled()).map(value => value: Boolean)
    override val snsTopic: Option[SNSTopic] = scala
      .Option(impl.snsTopic())
      .map(value => zio.aws.auditmanager.model.primitives.SNSTopic(value))
    override val defaultAssessmentReportsDestination: Option[
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ] = scala
      .Option(impl.defaultAssessmentReportsDestination())
      .map(value =>
        zio.aws.auditmanager.model.AssessmentReportsDestination.wrap(value)
      )
    override val defaultProcessOwners
        : Option[List[zio.aws.auditmanager.model.Role.ReadOnly]] = scala
      .Option(impl.defaultProcessOwners())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.Role.wrap(item)
        }.toList
      )
    override val kmsKey: Option[KmsKey] = scala
      .Option(impl.kmsKey())
      .map(value => zio.aws.auditmanager.model.primitives.KmsKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Settings
  ): zio.aws.auditmanager.model.Settings.ReadOnly = new Wrapper(impl)
}
