package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateAssessmentResponse(
    assessment: Option[zio.aws.auditmanager.model.Assessment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateAssessmentResponse = {
    import CreateAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentResponse
      .builder()
      .optionallyWith(assessment.map(value => value.buildAwsValue()))(
        _.assessment
      )
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.CreateAssessmentResponse.ReadOnly =
    zio.aws.auditmanager.model.CreateAssessmentResponse.wrap(buildAwsValue())
}
object CreateAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.CreateAssessmentResponse =
      zio.aws.auditmanager.model
        .CreateAssessmentResponse(assessment.map(value => value.asEditable))
    def assessment: Option[zio.aws.auditmanager.model.Assessment.ReadOnly]
    def getAssessment
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Assessment.ReadOnly] =
      AwsError.unwrapOptionField("assessment", assessment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentResponse
  ) extends zio.aws.auditmanager.model.CreateAssessmentResponse.ReadOnly {
    override val assessment
        : Option[zio.aws.auditmanager.model.Assessment.ReadOnly] = scala
      .Option(impl.assessment())
      .map(value => zio.aws.auditmanager.model.Assessment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentResponse
  ): zio.aws.auditmanager.model.CreateAssessmentResponse.ReadOnly = new Wrapper(
    impl
  )
}
