package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateAssessmentFrameworkResponse(
    framework: Option[zio.aws.auditmanager.model.Framework] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkResponse = {
    import CreateAssessmentFrameworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkResponse
      .builder()
      .optionallyWith(framework.map(value => value.buildAwsValue()))(
        _.framework
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse.ReadOnly =
    zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse
      .wrap(buildAwsValue())
}
object CreateAssessmentFrameworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse =
      zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse(
        framework.map(value => value.asEditable)
      )
    def framework: Option[zio.aws.auditmanager.model.Framework.ReadOnly]
    def getFramework
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Framework.ReadOnly] =
      AwsError.unwrapOptionField("framework", framework)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkResponse
  ) extends zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse.ReadOnly {
    override val framework
        : Option[zio.aws.auditmanager.model.Framework.ReadOnly] = scala
      .Option(impl.framework())
      .map(value => zio.aws.auditmanager.model.Framework.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkResponse
  ): zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse.ReadOnly =
    new Wrapper(impl)
}
