package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.{ControlSetId, UUID}
import scala.jdk.CollectionConverters.*
final case class BatchImportEvidenceToAssessmentControlRequest(
    assessmentId: UUID,
    controlSetId: ControlSetId,
    controlId: UUID,
    manualEvidence: Iterable[zio.aws.auditmanager.model.ManualEvidence]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest = {
    import BatchImportEvidenceToAssessmentControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .controlSetId(ControlSetId.unwrap(controlSetId): java.lang.String)
      .controlId(UUID.unwrap(controlId): java.lang.String)
      .manualEvidence(manualEvidence.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest.ReadOnly =
    zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest
      .wrap(buildAwsValue())
}
object BatchImportEvidenceToAssessmentControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest =
      zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest(
        assessmentId,
        controlSetId,
        controlId,
        manualEvidence.map { item =>
          item.asEditable
        }
      )
    def assessmentId: UUID
    def controlSetId: ControlSetId
    def controlId: UUID
    def manualEvidence: List[zio.aws.auditmanager.model.ManualEvidence.ReadOnly]
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getControlSetId: ZIO[Any, Nothing, ControlSetId] =
      ZIO.succeed(controlSetId)
    def getControlId: ZIO[Any, Nothing, UUID] = ZIO.succeed(controlId)
    def getManualEvidence: ZIO[Any, Nothing, List[
      zio.aws.auditmanager.model.ManualEvidence.ReadOnly
    ]] = ZIO.succeed(manualEvidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest
  ) extends zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val controlSetId: ControlSetId =
      zio.aws.auditmanager.model.primitives.ControlSetId(impl.controlSetId())
    override val controlId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.controlId())
    override val manualEvidence
        : List[zio.aws.auditmanager.model.ManualEvidence.ReadOnly] = impl
      .manualEvidence()
      .asScala
      .map { item =>
        zio.aws.auditmanager.model.ManualEvidence.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest
  ): zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest.ReadOnly =
    new Wrapper(impl)
}
