package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  AuditManagerArn,
  ActionPlanTitle,
  Timestamp,
  TagValue,
  TestingInformation,
  LastUpdatedBy,
  ActionPlanInstructions,
  UUID,
  ControlDescription,
  ControlSources,
  CreatedBy,
  ControlName,
  TagKey
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Control(
    arn: Option[AuditManagerArn] = None,
    id: Option[UUID] = None,
    `type`: Option[zio.aws.auditmanager.model.ControlType] = None,
    name: Option[ControlName] = None,
    description: Option[ControlDescription] = None,
    testingInformation: Option[TestingInformation] = None,
    actionPlanTitle: Option[ActionPlanTitle] = None,
    actionPlanInstructions: Option[ActionPlanInstructions] = None,
    controlSources: Option[ControlSources] = None,
    controlMappingSources: Option[
      Iterable[zio.aws.auditmanager.model.ControlMappingSource]
    ] = None,
    createdAt: Option[Timestamp] = None,
    lastUpdatedAt: Option[Timestamp] = None,
    createdBy: Option[CreatedBy] = None,
    lastUpdatedBy: Option[LastUpdatedBy] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Control = {
    import Control.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Control
      .builder()
      .optionallyWith(
        arn.map(value => AuditManagerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => ControlName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ControlDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        testingInformation.map(value =>
          TestingInformation.unwrap(value): java.lang.String
        )
      )(_.testingInformation)
      .optionallyWith(
        actionPlanTitle.map(value =>
          ActionPlanTitle.unwrap(value): java.lang.String
        )
      )(_.actionPlanTitle)
      .optionallyWith(
        actionPlanInstructions.map(value =>
          ActionPlanInstructions.unwrap(value): java.lang.String
        )
      )(_.actionPlanInstructions)
      .optionallyWith(
        controlSources.map(value =>
          ControlSources.unwrap(value): java.lang.String
        )
      )(_.controlSources)
      .optionallyWith(
        controlMappingSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlMappingSources)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        lastUpdatedBy.map(value =>
          LastUpdatedBy.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedBy)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Control.ReadOnly =
    zio.aws.auditmanager.model.Control.wrap(buildAwsValue())
}
object Control {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Control
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Control =
      zio.aws.auditmanager.model.Control(
        arn.map(value => value),
        id.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        testingInformation.map(value => value),
        actionPlanTitle.map(value => value),
        actionPlanInstructions.map(value => value),
        controlSources.map(value => value),
        controlMappingSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        createdBy.map(value => value),
        lastUpdatedBy.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[AuditManagerArn]
    def id: Option[UUID]
    def `type`: Option[zio.aws.auditmanager.model.ControlType]
    def name: Option[ControlName]
    def description: Option[ControlDescription]
    def testingInformation: Option[TestingInformation]
    def actionPlanTitle: Option[ActionPlanTitle]
    def actionPlanInstructions: Option[ActionPlanInstructions]
    def controlSources: Option[ControlSources]
    def controlMappingSources
        : Option[List[zio.aws.auditmanager.model.ControlMappingSource.ReadOnly]]
    def createdAt: Option[Timestamp]
    def lastUpdatedAt: Option[Timestamp]
    def createdBy: Option[CreatedBy]
    def lastUpdatedBy: Option[LastUpdatedBy]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, AuditManagerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.auditmanager.model.ControlType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, ControlName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ControlDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTestingInformation: ZIO[Any, AwsError, TestingInformation] =
      AwsError.unwrapOptionField("testingInformation", testingInformation)
    def getActionPlanTitle: ZIO[Any, AwsError, ActionPlanTitle] =
      AwsError.unwrapOptionField("actionPlanTitle", actionPlanTitle)
    def getActionPlanInstructions: ZIO[Any, AwsError, ActionPlanInstructions] =
      AwsError.unwrapOptionField(
        "actionPlanInstructions",
        actionPlanInstructions
      )
    def getControlSources: ZIO[Any, AwsError, ControlSources] =
      AwsError.unwrapOptionField("controlSources", controlSources)
    def getControlMappingSources: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlMappingSource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("controlMappingSources", controlMappingSources)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastUpdatedBy: ZIO[Any, AwsError, LastUpdatedBy] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Control
  ) extends zio.aws.auditmanager.model.Control.ReadOnly {
    override val arn: Option[AuditManagerArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AuditManagerArn(value)
      )
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val `type`: Option[zio.aws.auditmanager.model.ControlType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.auditmanager.model.ControlType.wrap(value))
    override val name: Option[ControlName] = scala
      .Option(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.ControlName(value))
    override val description: Option[ControlDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ControlDescription(value)
      )
    override val testingInformation: Option[TestingInformation] = scala
      .Option(impl.testingInformation())
      .map(value =>
        zio.aws.auditmanager.model.primitives.TestingInformation(value)
      )
    override val actionPlanTitle: Option[ActionPlanTitle] = scala
      .Option(impl.actionPlanTitle())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ActionPlanTitle(value)
      )
    override val actionPlanInstructions: Option[ActionPlanInstructions] = scala
      .Option(impl.actionPlanInstructions())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ActionPlanInstructions(value)
      )
    override val controlSources: Option[ControlSources] = scala
      .Option(impl.controlSources())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSources(value))
    override val controlMappingSources: Option[
      List[zio.aws.auditmanager.model.ControlMappingSource.ReadOnly]
    ] = scala
      .Option(impl.controlMappingSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.ControlMappingSource.wrap(item)
        }.toList
      )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Option[Timestamp] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val createdBy: Option[CreatedBy] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.auditmanager.model.primitives.CreatedBy(value))
    override val lastUpdatedBy: Option[LastUpdatedBy] = scala
      .Option(impl.lastUpdatedBy())
      .map(value => zio.aws.auditmanager.model.primitives.LastUpdatedBy(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.auditmanager.model.primitives.TagKey(
              key
            ) -> zio.aws.auditmanager.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Control
  ): zio.aws.auditmanager.model.Control.ReadOnly = new Wrapper(impl)
}
