package zio.aws.auditmanager.model
import java.time.Instant
import zio.aws.auditmanager.model.primitives.{
  FrameworkName,
  AccountId,
  Timestamp,
  ShareRequestComment,
  FrameworkDescription,
  ComplianceType,
  UUID,
  Region,
  NullableInteger
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AssessmentFrameworkShareRequest(
    id: Option[UUID] = None,
    frameworkId: Option[UUID] = None,
    frameworkName: Option[FrameworkName] = None,
    frameworkDescription: Option[FrameworkDescription] = None,
    status: Option[zio.aws.auditmanager.model.ShareRequestStatus] = None,
    sourceAccount: Option[AccountId] = None,
    destinationAccount: Option[AccountId] = None,
    destinationRegion: Option[Region] = None,
    expirationTime: Option[Timestamp] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdated: Option[Timestamp] = None,
    comment: Option[ShareRequestComment] = None,
    standardControlsCount: Option[NullableInteger] = None,
    customControlsCount: Option[NullableInteger] = None,
    complianceType: Option[ComplianceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest = {
    import AssessmentFrameworkShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        frameworkId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.frameworkId)
      .optionallyWith(
        frameworkName.map(value =>
          FrameworkName.unwrap(value): java.lang.String
        )
      )(_.frameworkName)
      .optionallyWith(
        frameworkDescription.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.frameworkDescription)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sourceAccount.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.sourceAccount)
      .optionallyWith(
        destinationAccount.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.destinationAccount)
      .optionallyWith(
        destinationRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.destinationRegion)
      .optionallyWith(
        expirationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationTime)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        comment.map(value =>
          ShareRequestComment.unwrap(value): java.lang.String
        )
      )(_.comment)
      .optionallyWith(
        standardControlsCount.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.standardControlsCount)
      .optionallyWith(
        customControlsCount.map(value => NullableInteger.unwrap(value): Integer)
      )(_.customControlsCount)
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly =
    zio.aws.auditmanager.model.AssessmentFrameworkShareRequest
      .wrap(buildAwsValue())
}
object AssessmentFrameworkShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentFrameworkShareRequest =
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest(
        id.map(value => value),
        frameworkId.map(value => value),
        frameworkName.map(value => value),
        frameworkDescription.map(value => value),
        status.map(value => value),
        sourceAccount.map(value => value),
        destinationAccount.map(value => value),
        destinationRegion.map(value => value),
        expirationTime.map(value => value),
        creationTime.map(value => value),
        lastUpdated.map(value => value),
        comment.map(value => value),
        standardControlsCount.map(value => value),
        customControlsCount.map(value => value),
        complianceType.map(value => value)
      )
    def id: Option[UUID]
    def frameworkId: Option[UUID]
    def frameworkName: Option[FrameworkName]
    def frameworkDescription: Option[FrameworkDescription]
    def status: Option[zio.aws.auditmanager.model.ShareRequestStatus]
    def sourceAccount: Option[AccountId]
    def destinationAccount: Option[AccountId]
    def destinationRegion: Option[Region]
    def expirationTime: Option[Timestamp]
    def creationTime: Option[Timestamp]
    def lastUpdated: Option[Timestamp]
    def comment: Option[ShareRequestComment]
    def standardControlsCount: Option[NullableInteger]
    def customControlsCount: Option[NullableInteger]
    def complianceType: Option[ComplianceType]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getFrameworkId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("frameworkId", frameworkId)
    def getFrameworkName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("frameworkName", frameworkName)
    def getFrameworkDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("frameworkDescription", frameworkDescription)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ShareRequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSourceAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("sourceAccount", sourceAccount)
    def getDestinationAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("destinationAccount", destinationAccount)
    def getDestinationRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("destinationRegion", destinationRegion)
    def getExpirationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getComment: ZIO[Any, AwsError, ShareRequestComment] =
      AwsError.unwrapOptionField("comment", comment)
    def getStandardControlsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("standardControlsCount", standardControlsCount)
    def getCustomControlsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("customControlsCount", customControlsCount)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest
  ) extends zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly {
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val frameworkId: Option[UUID] = scala
      .Option(impl.frameworkId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val frameworkName: Option[FrameworkName] = scala
      .Option(impl.frameworkName())
      .map(value => zio.aws.auditmanager.model.primitives.FrameworkName(value))
    override val frameworkDescription: Option[FrameworkDescription] = scala
      .Option(impl.frameworkDescription())
      .map(value =>
        zio.aws.auditmanager.model.primitives.FrameworkDescription(value)
      )
    override val status: Option[zio.aws.auditmanager.model.ShareRequestStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.auditmanager.model.ShareRequestStatus.wrap(value))
    override val sourceAccount: Option[AccountId] = scala
      .Option(impl.sourceAccount())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val destinationAccount: Option[AccountId] = scala
      .Option(impl.destinationAccount())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val destinationRegion: Option[Region] = scala
      .Option(impl.destinationRegion())
      .map(value => zio.aws.auditmanager.model.primitives.Region(value))
    override val expirationTime: Option[Timestamp] = scala
      .Option(impl.expirationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val comment: Option[ShareRequestComment] = scala
      .Option(impl.comment())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ShareRequestComment(value)
      )
    override val standardControlsCount: Option[NullableInteger] = scala
      .Option(impl.standardControlsCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val customControlsCount: Option[NullableInteger] = scala
      .Option(impl.customControlsCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val complianceType: Option[ComplianceType] = scala
      .Option(impl.complianceType())
      .map(value => zio.aws.auditmanager.model.primitives.ComplianceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest
  ): zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly =
    new Wrapper(impl)
}
