package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class ListControlInsightsByControlDomainResponse(
    controlInsightsMetadata: Option[
      Iterable[zio.aws.auditmanager.model.ControlInsightsMetadataItem]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse = {
    import ListControlInsightsByControlDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse
      .builder()
      .optionallyWith(
        controlInsightsMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlInsightsMetadata)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse.ReadOnly =
    zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse
      .wrap(buildAwsValue())
}
object ListControlInsightsByControlDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse =
      zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse(
        controlInsightsMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def controlInsightsMetadata: Option[
      List[zio.aws.auditmanager.model.ControlInsightsMetadataItem.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getControlInsightsMetadata: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlInsightsMetadataItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "controlInsightsMetadata",
      controlInsightsMetadata
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse
  ) extends zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse.ReadOnly {
    override val controlInsightsMetadata: Option[
      List[zio.aws.auditmanager.model.ControlInsightsMetadataItem.ReadOnly]
    ] = scala
      .Option(impl.controlInsightsMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.ControlInsightsMetadataItem.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse
  ): zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse.ReadOnly =
    new Wrapper(impl)
}
