package zio.aws.auditmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{MaxResults, Token}
import scala.jdk.CollectionConverters.*
final case class ListAssessmentsRequest(
    status: Option[zio.aws.auditmanager.model.AssessmentStatus] = None,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest = {
    import ListAssessmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ListAssessmentsRequest.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentsRequest.wrap(buildAwsValue())
}
object ListAssessmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListAssessmentsRequest =
      zio.aws.auditmanager.model.ListAssessmentsRequest(
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def status: Option[zio.aws.auditmanager.model.AssessmentStatus]
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.AssessmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest
  ) extends zio.aws.auditmanager.model.ListAssessmentsRequest.ReadOnly {
    override val status: Option[zio.aws.auditmanager.model.AssessmentStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.auditmanager.model.AssessmentStatus.wrap(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest
  ): zio.aws.auditmanager.model.ListAssessmentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
