package zio.aws.auditmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{MaxResults, Token}
import scala.jdk.CollectionConverters.*
final case class ListAssessmentReportsRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest = {
    import ListAssessmentReportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListAssessmentReportsRequest.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentReportsRequest
      .wrap(buildAwsValue())
}
object ListAssessmentReportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListAssessmentReportsRequest =
      zio.aws.auditmanager.model.ListAssessmentReportsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest
  ) extends zio.aws.auditmanager.model.ListAssessmentReportsRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest
  ): zio.aws.auditmanager.model.ListAssessmentReportsRequest.ReadOnly =
    new Wrapper(impl)
}
