package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ActionPlanTitle,
  TestingInformation,
  ActionPlanInstructions,
  UUID,
  ControlDescription,
  ControlName
}
import scala.jdk.CollectionConverters.*
final case class UpdateControlRequest(
    controlId: UUID,
    name: ControlName,
    description: Option[ControlDescription] = None,
    testingInformation: Option[TestingInformation] = None,
    actionPlanTitle: Option[ActionPlanTitle] = None,
    actionPlanInstructions: Option[ActionPlanInstructions] = None,
    controlMappingSources: Iterable[
      zio.aws.auditmanager.model.ControlMappingSource
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest = {
    import UpdateControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest
      .builder()
      .controlId(UUID.unwrap(controlId): java.lang.String)
      .name(ControlName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ControlDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        testingInformation.map(value =>
          TestingInformation.unwrap(value): java.lang.String
        )
      )(_.testingInformation)
      .optionallyWith(
        actionPlanTitle.map(value =>
          ActionPlanTitle.unwrap(value): java.lang.String
        )
      )(_.actionPlanTitle)
      .optionallyWith(
        actionPlanInstructions.map(value =>
          ActionPlanInstructions.unwrap(value): java.lang.String
        )
      )(_.actionPlanInstructions)
      .controlMappingSources(controlMappingSources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.UpdateControlRequest.ReadOnly =
    zio.aws.auditmanager.model.UpdateControlRequest.wrap(buildAwsValue())
}
object UpdateControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateControlRequest =
      zio.aws.auditmanager.model.UpdateControlRequest(
        controlId,
        name,
        description.map(value => value),
        testingInformation.map(value => value),
        actionPlanTitle.map(value => value),
        actionPlanInstructions.map(value => value),
        controlMappingSources.map { item =>
          item.asEditable
        }
      )
    def controlId: UUID
    def name: ControlName
    def description: Option[ControlDescription]
    def testingInformation: Option[TestingInformation]
    def actionPlanTitle: Option[ActionPlanTitle]
    def actionPlanInstructions: Option[ActionPlanInstructions]
    def controlMappingSources
        : List[zio.aws.auditmanager.model.ControlMappingSource.ReadOnly]
    def getControlId: ZIO[Any, Nothing, UUID] = ZIO.succeed(controlId)
    def getName: ZIO[Any, Nothing, ControlName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ControlDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTestingInformation: ZIO[Any, AwsError, TestingInformation] =
      AwsError.unwrapOptionField("testingInformation", testingInformation)
    def getActionPlanTitle: ZIO[Any, AwsError, ActionPlanTitle] =
      AwsError.unwrapOptionField("actionPlanTitle", actionPlanTitle)
    def getActionPlanInstructions: ZIO[Any, AwsError, ActionPlanInstructions] =
      AwsError.unwrapOptionField(
        "actionPlanInstructions",
        actionPlanInstructions
      )
    def getControlMappingSources: ZIO[Any, Nothing, List[
      zio.aws.auditmanager.model.ControlMappingSource.ReadOnly
    ]] = ZIO.succeed(controlMappingSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest
  ) extends zio.aws.auditmanager.model.UpdateControlRequest.ReadOnly {
    override val controlId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.controlId())
    override val name: ControlName =
      zio.aws.auditmanager.model.primitives.ControlName(impl.name())
    override val description: Option[ControlDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ControlDescription(value)
      )
    override val testingInformation: Option[TestingInformation] = scala
      .Option(impl.testingInformation())
      .map(value =>
        zio.aws.auditmanager.model.primitives.TestingInformation(value)
      )
    override val actionPlanTitle: Option[ActionPlanTitle] = scala
      .Option(impl.actionPlanTitle())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ActionPlanTitle(value)
      )
    override val actionPlanInstructions: Option[ActionPlanInstructions] = scala
      .Option(impl.actionPlanInstructions())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ActionPlanInstructions(value)
      )
    override val controlMappingSources
        : List[zio.aws.auditmanager.model.ControlMappingSource.ReadOnly] = impl
      .controlMappingSources()
      .asScala
      .map { item =>
        zio.aws.auditmanager.model.ControlMappingSource.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest
  ): zio.aws.auditmanager.model.UpdateControlRequest.ReadOnly = new Wrapper(
    impl
  )
}
