package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ControlSetId,
  AssessmentName,
  TimestampUUID,
  Timestamp,
  UUID,
  NonEmptyString
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Notification(
    id: Option[TimestampUUID] = None,
    assessmentId: Option[UUID] = None,
    assessmentName: Option[AssessmentName] = None,
    controlSetId: Option[ControlSetId] = None,
    controlSetName: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    eventTime: Option[Timestamp] = None,
    source: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Notification = {
    import Notification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Notification
      .builder()
      .optionallyWith(
        id.map(value => TimestampUUID.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        assessmentId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.assessmentId)
      .optionallyWith(
        assessmentName.map(value =>
          AssessmentName.unwrap(value): java.lang.String
        )
      )(_.assessmentName)
      .optionallyWith(
        controlSetId.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.controlSetId)
      .optionallyWith(
        controlSetName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.controlSetName)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(eventTime.map(value => Timestamp.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(
        source.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.source)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Notification.ReadOnly =
    zio.aws.auditmanager.model.Notification.wrap(buildAwsValue())
}
object Notification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Notification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Notification =
      zio.aws.auditmanager.model.Notification(
        id.map(value => value),
        assessmentId.map(value => value),
        assessmentName.map(value => value),
        controlSetId.map(value => value),
        controlSetName.map(value => value),
        description.map(value => value),
        eventTime.map(value => value),
        source.map(value => value)
      )
    def id: Option[TimestampUUID]
    def assessmentId: Option[UUID]
    def assessmentName: Option[AssessmentName]
    def controlSetId: Option[ControlSetId]
    def controlSetName: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def eventTime: Option[Timestamp]
    def source: Option[NonEmptyString]
    def getId: ZIO[Any, AwsError, TimestampUUID] =
      AwsError.unwrapOptionField("id", id)
    def getAssessmentId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("assessmentId", assessmentId)
    def getAssessmentName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("assessmentName", assessmentName)
    def getControlSetId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("controlSetId", controlSetId)
    def getControlSetName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("controlSetName", controlSetName)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Notification
  ) extends zio.aws.auditmanager.model.Notification.ReadOnly {
    override val id: Option[TimestampUUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.TimestampUUID(value))
    override val assessmentId: Option[UUID] = scala
      .Option(impl.assessmentId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val assessmentName: Option[AssessmentName] = scala
      .Option(impl.assessmentName())
      .map(value => zio.aws.auditmanager.model.primitives.AssessmentName(value))
    override val controlSetId: Option[ControlSetId] = scala
      .Option(impl.controlSetId())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val controlSetName: Option[NonEmptyString] = scala
      .Option(impl.controlSetName())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val eventTime: Option[Timestamp] = scala
      .Option(impl.eventTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val source: Option[NonEmptyString] = scala
      .Option(impl.source())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Notification
  ): zio.aws.auditmanager.model.Notification.ReadOnly = new Wrapper(impl)
}
