package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.AuditManagerArn
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: AuditManagerArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AuditManagerArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.auditmanager.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListTagsForResourceRequest =
      zio.aws.auditmanager.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AuditManagerArn
    def getResourceArn: ZIO[Any, Nothing, AuditManagerArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest
  ) extends zio.aws.auditmanager.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AuditManagerArn =
      zio.aws.auditmanager.model.primitives.AuditManagerArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest
  ): zio.aws.auditmanager.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
