package zio.aws.auditmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{MaxResults, Token}
import scala.jdk.CollectionConverters.*
final case class ListKeywordsForDataSourceRequest(
    source: zio.aws.auditmanager.model.SourceType,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest = {
    import ListKeywordsForDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest
      .builder()
      .source(source.unwrap)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListKeywordsForDataSourceRequest.ReadOnly =
    zio.aws.auditmanager.model.ListKeywordsForDataSourceRequest
      .wrap(buildAwsValue())
}
object ListKeywordsForDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListKeywordsForDataSourceRequest =
      zio.aws.auditmanager.model.ListKeywordsForDataSourceRequest(
        source,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def source: zio.aws.auditmanager.model.SourceType
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getSource: ZIO[Any, Nothing, zio.aws.auditmanager.model.SourceType] =
      ZIO.succeed(source)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest
  ) extends zio.aws.auditmanager.model.ListKeywordsForDataSourceRequest.ReadOnly {
    override val source: zio.aws.auditmanager.model.SourceType =
      zio.aws.auditmanager.model.SourceType.wrap(impl.source())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest
  ): zio.aws.auditmanager.model.ListKeywordsForDataSourceRequest.ReadOnly =
    new Wrapper(impl)
}
