package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ComplianceType,
  Filename,
  AssessmentFrameworkDescription,
  AssessmentName
}
import scala.jdk.CollectionConverters.*
final case class FrameworkMetadata(
    name: Option[AssessmentName] = None,
    description: Option[AssessmentFrameworkDescription] = None,
    logo: Option[Filename] = None,
    complianceType: Option[ComplianceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata = {
    import FrameworkMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata
      .builder()
      .optionallyWith(
        name.map(value => AssessmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AssessmentFrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        logo.map(value => Filename.unwrap(value): java.lang.String)
      )(_.logo)
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.FrameworkMetadata.ReadOnly =
    zio.aws.auditmanager.model.FrameworkMetadata.wrap(buildAwsValue())
}
object FrameworkMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.FrameworkMetadata =
      zio.aws.auditmanager.model.FrameworkMetadata(
        name.map(value => value),
        description.map(value => value),
        logo.map(value => value),
        complianceType.map(value => value)
      )
    def name: Option[AssessmentName]
    def description: Option[AssessmentFrameworkDescription]
    def logo: Option[Filename]
    def complianceType: Option[ComplianceType]
    def getName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AssessmentFrameworkDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLogo: ZIO[Any, AwsError, Filename] =
      AwsError.unwrapOptionField("logo", logo)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata
  ) extends zio.aws.auditmanager.model.FrameworkMetadata.ReadOnly {
    override val name: Option[AssessmentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.AssessmentName(value))
    override val description: Option[AssessmentFrameworkDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives
          .AssessmentFrameworkDescription(value)
      )
    override val logo: Option[Filename] = scala
      .Option(impl.logo())
      .map(value => zio.aws.auditmanager.model.primitives.Filename(value))
    override val complianceType: Option[ComplianceType] = scala
      .Option(impl.complianceType())
      .map(value => zio.aws.auditmanager.model.primitives.ComplianceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata
  ): zio.aws.auditmanager.model.FrameworkMetadata.ReadOnly = new Wrapper(impl)
}
