package zio.aws.auditmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.NullableInteger
import scala.jdk.CollectionConverters.*
final case class EvidenceInsights(
    noncompliantEvidenceCount: Option[NullableInteger] = None,
    compliantEvidenceCount: Option[NullableInteger] = None,
    inconclusiveEvidenceCount: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.EvidenceInsights = {
    import EvidenceInsights.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.EvidenceInsights
      .builder()
      .optionallyWith(
        noncompliantEvidenceCount.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.noncompliantEvidenceCount)
      .optionallyWith(
        compliantEvidenceCount.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.compliantEvidenceCount)
      .optionallyWith(
        inconclusiveEvidenceCount.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.inconclusiveEvidenceCount)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.EvidenceInsights.ReadOnly =
    zio.aws.auditmanager.model.EvidenceInsights.wrap(buildAwsValue())
}
object EvidenceInsights {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.EvidenceInsights
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.EvidenceInsights =
      zio.aws.auditmanager.model.EvidenceInsights(
        noncompliantEvidenceCount.map(value => value),
        compliantEvidenceCount.map(value => value),
        inconclusiveEvidenceCount.map(value => value)
      )
    def noncompliantEvidenceCount: Option[NullableInteger]
    def compliantEvidenceCount: Option[NullableInteger]
    def inconclusiveEvidenceCount: Option[NullableInteger]
    def getNoncompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "noncompliantEvidenceCount",
        noncompliantEvidenceCount
      )
    def getCompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "compliantEvidenceCount",
        compliantEvidenceCount
      )
    def getInconclusiveEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "inconclusiveEvidenceCount",
        inconclusiveEvidenceCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.EvidenceInsights
  ) extends zio.aws.auditmanager.model.EvidenceInsights.ReadOnly {
    override val noncompliantEvidenceCount: Option[NullableInteger] = scala
      .Option(impl.noncompliantEvidenceCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val compliantEvidenceCount: Option[NullableInteger] = scala
      .Option(impl.compliantEvidenceCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val inconclusiveEvidenceCount: Option[NullableInteger] = scala
      .Option(impl.inconclusiveEvidenceCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.EvidenceInsights
  ): zio.aws.auditmanager.model.EvidenceInsights.ReadOnly = new Wrapper(impl)
}
