package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class DisassociateAssessmentReportEvidenceFolderRequest(
    assessmentId: UUID,
    evidenceFolderId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest = {
    import DisassociateAssessmentReportEvidenceFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .evidenceFolderId(UUID.unwrap(evidenceFolderId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest.ReadOnly =
    zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest
      .wrap(buildAwsValue())
}
object DisassociateAssessmentReportEvidenceFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest =
      zio.aws.auditmanager.model
        .DisassociateAssessmentReportEvidenceFolderRequest(
          assessmentId,
          evidenceFolderId
        )
    def assessmentId: UUID
    def evidenceFolderId: UUID
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getEvidenceFolderId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(evidenceFolderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest
  ) extends zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val evidenceFolderId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.evidenceFolderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest
  ): zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest.ReadOnly =
    new Wrapper(impl)
}
