package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  Timestamp,
  ControlCommentBody,
  Username
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ControlComment(
    authorName: Option[Username] = None,
    commentBody: Option[ControlCommentBody] = None,
    postedDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ControlComment = {
    import ControlComment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ControlComment
      .builder()
      .optionallyWith(
        authorName.map(value => Username.unwrap(value): java.lang.String)
      )(_.authorName)
      .optionallyWith(
        commentBody.map(value =>
          ControlCommentBody.unwrap(value): java.lang.String
        )
      )(_.commentBody)
      .optionallyWith(
        postedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.postedDate)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ControlComment.ReadOnly =
    zio.aws.auditmanager.model.ControlComment.wrap(buildAwsValue())
}
object ControlComment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ControlComment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ControlComment =
      zio.aws.auditmanager.model.ControlComment(
        authorName.map(value => value),
        commentBody.map(value => value),
        postedDate.map(value => value)
      )
    def authorName: Option[Username]
    def commentBody: Option[ControlCommentBody]
    def postedDate: Option[Timestamp]
    def getAuthorName: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("authorName", authorName)
    def getCommentBody: ZIO[Any, AwsError, ControlCommentBody] =
      AwsError.unwrapOptionField("commentBody", commentBody)
    def getPostedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("postedDate", postedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlComment
  ) extends zio.aws.auditmanager.model.ControlComment.ReadOnly {
    override val authorName: Option[Username] = scala
      .Option(impl.authorName())
      .map(value => zio.aws.auditmanager.model.primitives.Username(value))
    override val commentBody: Option[ControlCommentBody] = scala
      .Option(impl.commentBody())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ControlCommentBody(value)
      )
    override val postedDate: Option[Timestamp] = scala
      .Option(impl.postedDate())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlComment
  ): zio.aws.auditmanager.model.ControlComment.ReadOnly = new Wrapper(impl)
}
