package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class BatchDeleteDelegationByAssessmentRequest(
    delegationIds: Iterable[UUID],
    assessmentId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest = {
    import BatchDeleteDelegationByAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest
      .builder()
      .delegationIds(delegationIds.map { item =>
        UUID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentRequest.ReadOnly =
    zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentRequest
      .wrap(buildAwsValue())
}
object BatchDeleteDelegationByAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentRequest =
      zio.aws.auditmanager.model
        .BatchDeleteDelegationByAssessmentRequest(delegationIds, assessmentId)
    def delegationIds: List[UUID]
    def assessmentId: UUID
    def getDelegationIds: ZIO[Any, Nothing, List[UUID]] =
      ZIO.succeed(delegationIds)
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest
  ) extends zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentRequest.ReadOnly {
    override val delegationIds: List[UUID] = impl
      .delegationIds()
      .asScala
      .map { item =>
        zio.aws.auditmanager.model.primitives.UUID(item)
      }
      .toList
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest
  ): zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentRequest.ReadOnly =
    new Wrapper(impl)
}
