package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  Integer,
  NonEmptyString,
  ControlSetId
}
import scala.jdk.CollectionConverters.*
final case class AssessmentControlSet(
    id: Option[ControlSetId] = None,
    description: Option[NonEmptyString] = None,
    status: Option[zio.aws.auditmanager.model.ControlSetStatus] = None,
    roles: Option[Iterable[zio.aws.auditmanager.model.Role]] = None,
    controls: Option[Iterable[zio.aws.auditmanager.model.AssessmentControl]] =
      None,
    delegations: Option[Iterable[zio.aws.auditmanager.model.Delegation]] = None,
    systemEvidenceCount: Option[Integer] = None,
    manualEvidenceCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet = {
    import AssessmentControlSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet
      .builder()
      .optionallyWith(
        id.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roles)
      .optionallyWith(
        controls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controls)
      .optionallyWith(
        delegations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.delegations)
      .optionallyWith(
        systemEvidenceCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.systemEvidenceCount)
      .optionallyWith(
        manualEvidenceCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.manualEvidenceCount)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly =
    zio.aws.auditmanager.model.AssessmentControlSet.wrap(buildAwsValue())
}
object AssessmentControlSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentControlSet =
      zio.aws.auditmanager.model.AssessmentControlSet(
        id.map(value => value),
        description.map(value => value),
        status.map(value => value),
        roles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        controls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        delegations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        systemEvidenceCount.map(value => value),
        manualEvidenceCount.map(value => value)
      )
    def id: Option[ControlSetId]
    def description: Option[NonEmptyString]
    def status: Option[zio.aws.auditmanager.model.ControlSetStatus]
    def roles: Option[List[zio.aws.auditmanager.model.Role.ReadOnly]]
    def controls
        : Option[List[zio.aws.auditmanager.model.AssessmentControl.ReadOnly]]
    def delegations
        : Option[List[zio.aws.auditmanager.model.Delegation.ReadOnly]]
    def systemEvidenceCount: Option[Integer]
    def manualEvidenceCount: Option[Integer]
    def getId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ControlSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoles
        : ZIO[Any, AwsError, List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      AwsError.unwrapOptionField("roles", roles)
    def getControls: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentControl.ReadOnly
    ]] = AwsError.unwrapOptionField("controls", controls)
    def getDelegations: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Delegation.ReadOnly
    ]] = AwsError.unwrapOptionField("delegations", delegations)
    def getSystemEvidenceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("systemEvidenceCount", systemEvidenceCount)
    def getManualEvidenceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("manualEvidenceCount", manualEvidenceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet
  ) extends zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly {
    override val id: Option[ControlSetId] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val status: Option[zio.aws.auditmanager.model.ControlSetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.auditmanager.model.ControlSetStatus.wrap(value))
    override val roles: Option[List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      scala
        .Option(impl.roles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Role.wrap(item)
          }.toList
        )
    override val controls
        : Option[List[zio.aws.auditmanager.model.AssessmentControl.ReadOnly]] =
      scala
        .Option(impl.controls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.AssessmentControl.wrap(item)
          }.toList
        )
    override val delegations
        : Option[List[zio.aws.auditmanager.model.Delegation.ReadOnly]] = scala
      .Option(impl.delegations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.Delegation.wrap(item)
        }.toList
      )
    override val systemEvidenceCount: Option[Integer] = scala
      .Option(impl.systemEvidenceCount())
      .map(value => zio.aws.auditmanager.model.primitives.Integer(value))
    override val manualEvidenceCount: Option[Integer] = scala
      .Option(impl.manualEvidenceCount())
      .map(value => zio.aws.auditmanager.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet
  ): zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly = new Wrapper(
    impl
  )
}
