package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{TagValue, TagKey, AuditManagerArn}
import scala.jdk.CollectionConverters.*
final case class Assessment(
    arn: Option[AuditManagerArn] = None,
    awsAccount: Option[zio.aws.auditmanager.model.AWSAccount] = None,
    metadata: Option[zio.aws.auditmanager.model.AssessmentMetadata] = None,
    framework: Option[zio.aws.auditmanager.model.AssessmentFramework] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Assessment = {
    import Assessment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Assessment
      .builder()
      .optionallyWith(
        arn.map(value => AuditManagerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(awsAccount.map(value => value.buildAwsValue()))(
        _.awsAccount
      )
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(framework.map(value => value.buildAwsValue()))(
        _.framework
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Assessment.ReadOnly =
    zio.aws.auditmanager.model.Assessment.wrap(buildAwsValue())
}
object Assessment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Assessment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Assessment =
      zio.aws.auditmanager.model.Assessment(
        arn.map(value => value),
        awsAccount.map(value => value.asEditable),
        metadata.map(value => value.asEditable),
        framework.map(value => value.asEditable),
        tags.map(value => value)
      )
    def arn: Option[AuditManagerArn]
    def awsAccount: Option[zio.aws.auditmanager.model.AWSAccount.ReadOnly]
    def metadata: Option[zio.aws.auditmanager.model.AssessmentMetadata.ReadOnly]
    def framework
        : Option[zio.aws.auditmanager.model.AssessmentFramework.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, AuditManagerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAwsAccount
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.AWSAccount.ReadOnly] =
      AwsError.unwrapOptionField("awsAccount", awsAccount)
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
    def getFramework: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentFramework.ReadOnly
    ] = AwsError.unwrapOptionField("framework", framework)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Assessment
  ) extends zio.aws.auditmanager.model.Assessment.ReadOnly {
    override val arn: Option[AuditManagerArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AuditManagerArn(value)
      )
    override val awsAccount
        : Option[zio.aws.auditmanager.model.AWSAccount.ReadOnly] = scala
      .Option(impl.awsAccount())
      .map(value => zio.aws.auditmanager.model.AWSAccount.wrap(value))
    override val metadata
        : Option[zio.aws.auditmanager.model.AssessmentMetadata.ReadOnly] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.auditmanager.model.AssessmentMetadata.wrap(value))
    override val framework
        : Option[zio.aws.auditmanager.model.AssessmentFramework.ReadOnly] =
      scala
        .Option(impl.framework())
        .map(value =>
          zio.aws.auditmanager.model.AssessmentFramework.wrap(value)
        )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.auditmanager.model.primitives.TagKey(
              key
            ) -> zio.aws.auditmanager.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Assessment
  ): zio.aws.auditmanager.model.Assessment.ReadOnly = new Wrapper(impl)
}
