package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAssessmentStatusResponse(
    assessment: Option[zio.aws.auditmanager.model.Assessment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse = {
    import UpdateAssessmentStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse
      .builder()
      .optionallyWith(assessment.map(value => value.buildAwsValue()))(
        _.assessment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentStatusResponse
      .wrap(buildAwsValue())
}
object UpdateAssessmentStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateAssessmentStatusResponse =
      zio.aws.auditmanager.model.UpdateAssessmentStatusResponse(
        assessment.map(value => value.asEditable)
      )
    def assessment: Option[zio.aws.auditmanager.model.Assessment.ReadOnly]
    def getAssessment
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Assessment.ReadOnly] =
      AwsError.unwrapOptionField("assessment", assessment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse
  ) extends zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly {
    override val assessment
        : Option[zio.aws.auditmanager.model.Assessment.ReadOnly] = scala
      .Option(impl.assessment())
      .map(value => zio.aws.auditmanager.model.Assessment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse
  ): zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly =
    new Wrapper(impl)
}
