package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class ListAssessmentFrameworkShareRequestsResponse(
    assessmentFrameworkShareRequests: Option[
      Iterable[zio.aws.auditmanager.model.AssessmentFrameworkShareRequest]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse = {
    import ListAssessmentFrameworkShareRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
      .builder()
      .optionallyWith(
        assessmentFrameworkShareRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assessmentFrameworkShareRequests)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
      .wrap(buildAwsValue())
}
object ListAssessmentFrameworkShareRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse =
      zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse(
        assessmentFrameworkShareRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def assessmentFrameworkShareRequests: Option[
      List[zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getAssessmentFrameworkShareRequests: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "assessmentFrameworkShareRequests",
      assessmentFrameworkShareRequests
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
  ) extends zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly {
    override val assessmentFrameworkShareRequests: Option[
      List[zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly]
    ] = scala
      .Option(impl.assessmentFrameworkShareRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
  ): zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly =
    new Wrapper(impl)
}
