package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.{ControlSetId, UUID}
import scala.jdk.CollectionConverters.*
final case class GetEvidenceRequest(
    assessmentId: UUID,
    controlSetId: ControlSetId,
    evidenceFolderId: UUID,
    evidenceId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest = {
    import GetEvidenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .controlSetId(ControlSetId.unwrap(controlSetId): java.lang.String)
      .evidenceFolderId(UUID.unwrap(evidenceFolderId): java.lang.String)
      .evidenceId(UUID.unwrap(evidenceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetEvidenceRequest.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceRequest.wrap(buildAwsValue())
}
object GetEvidenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetEvidenceRequest =
      zio.aws.auditmanager.model.GetEvidenceRequest(
        assessmentId,
        controlSetId,
        evidenceFolderId,
        evidenceId
      )
    def assessmentId: UUID
    def controlSetId: ControlSetId
    def evidenceFolderId: UUID
    def evidenceId: UUID
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getControlSetId: ZIO[Any, Nothing, ControlSetId] =
      ZIO.succeed(controlSetId)
    def getEvidenceFolderId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(evidenceFolderId)
    def getEvidenceId: ZIO[Any, Nothing, UUID] = ZIO.succeed(evidenceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest
  ) extends zio.aws.auditmanager.model.GetEvidenceRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val controlSetId: ControlSetId =
      zio.aws.auditmanager.model.primitives.ControlSetId(impl.controlSetId())
    override val evidenceFolderId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.evidenceFolderId())
    override val evidenceId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.evidenceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest
  ): zio.aws.auditmanager.model.GetEvidenceRequest.ReadOnly = new Wrapper(impl)
}
