package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  AssessmentName,
  TagValue,
  UUID,
  AssessmentDescription,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateAssessmentRequest(
    name: AssessmentName,
    description: Option[AssessmentDescription] = None,
    assessmentReportsDestination: zio.aws.auditmanager.model.AssessmentReportsDestination,
    scope: zio.aws.auditmanager.model.Scope,
    roles: Iterable[zio.aws.auditmanager.model.Role],
    frameworkId: UUID,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest = {
    import CreateAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest
      .builder()
      .name(AssessmentName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          AssessmentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .assessmentReportsDestination(
        assessmentReportsDestination.buildAwsValue()
      )
      .scope(scope.buildAwsValue())
      .roles(roles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .frameworkId(UUID.unwrap(frameworkId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.CreateAssessmentRequest.ReadOnly =
    zio.aws.auditmanager.model.CreateAssessmentRequest.wrap(buildAwsValue())
}
object CreateAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.CreateAssessmentRequest =
      zio.aws.auditmanager.model.CreateAssessmentRequest(
        name,
        description.map(value => value),
        assessmentReportsDestination.asEditable,
        scope.asEditable,
        roles.map { item =>
          item.asEditable
        },
        frameworkId,
        tags.map(value => value)
      )
    def name: AssessmentName
    def description: Option[AssessmentDescription]
    def assessmentReportsDestination
        : zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    def scope: zio.aws.auditmanager.model.Scope.ReadOnly
    def roles: List[zio.aws.auditmanager.model.Role.ReadOnly]
    def frameworkId: UUID
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, AssessmentName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, AssessmentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAssessmentReportsDestination: ZIO[
      Any,
      Nothing,
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ] = ZIO.succeed(assessmentReportsDestination)
    def getScope: ZIO[Any, Nothing, zio.aws.auditmanager.model.Scope.ReadOnly] =
      ZIO.succeed(scope)
    def getRoles
        : ZIO[Any, Nothing, List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      ZIO.succeed(roles)
    def getFrameworkId: ZIO[Any, Nothing, UUID] = ZIO.succeed(frameworkId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest
  ) extends zio.aws.auditmanager.model.CreateAssessmentRequest.ReadOnly {
    override val name: AssessmentName =
      zio.aws.auditmanager.model.primitives.AssessmentName(impl.name())
    override val description: Option[AssessmentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AssessmentDescription(value)
      )
    override val assessmentReportsDestination
        : zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly =
      zio.aws.auditmanager.model.AssessmentReportsDestination
        .wrap(impl.assessmentReportsDestination())
    override val scope: zio.aws.auditmanager.model.Scope.ReadOnly =
      zio.aws.auditmanager.model.Scope.wrap(impl.scope())
    override val roles: List[zio.aws.auditmanager.model.Role.ReadOnly] = impl
      .roles()
      .asScala
      .map { item =>
        zio.aws.auditmanager.model.Role.wrap(item)
      }
      .toList
    override val frameworkId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.frameworkId())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.auditmanager.model.primitives.TagKey(
              key
            ) -> zio.aws.auditmanager.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest
  ): zio.aws.auditmanager.model.CreateAssessmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
