package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAssessmentFrameworkResponse(
    framework: Optional[zio.aws.auditmanager.model.Framework] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkResponse = {
    import UpdateAssessmentFrameworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkResponse
      .builder()
      .optionallyWith(framework.map(value => value.buildAwsValue()))(
        _.framework
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse
      .wrap(buildAwsValue())
}
object UpdateAssessmentFrameworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse =
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse(
        framework.map(value => value.asEditable)
      )
    def framework: Optional[zio.aws.auditmanager.model.Framework.ReadOnly]
    def getFramework
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Framework.ReadOnly] =
      AwsError.unwrapOptionField("framework", framework)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkResponse
  ) extends zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse.ReadOnly {
    override val framework
        : Optional[zio.aws.auditmanager.model.Framework.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.framework())
        .map(value => zio.aws.auditmanager.model.Framework.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkResponse
  ): zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse.ReadOnly =
    new Wrapper(impl)
}
