package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterAccountResponse(
    status: Optional[zio.aws.auditmanager.model.AccountStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.RegisterAccountResponse = {
    import RegisterAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.RegisterAccountResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.RegisterAccountResponse.ReadOnly =
    zio.aws.auditmanager.model.RegisterAccountResponse.wrap(buildAwsValue())
}
object RegisterAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.RegisterAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.RegisterAccountResponse =
      zio.aws.auditmanager.model
        .RegisterAccountResponse(status.map(value => value))
    def status: Optional[zio.aws.auditmanager.model.AccountStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.AccountStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.RegisterAccountResponse
  ) extends zio.aws.auditmanager.model.RegisterAccountResponse.ReadOnly {
    override val status: Optional[zio.aws.auditmanager.model.AccountStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.auditmanager.model.AccountStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.RegisterAccountResponse
  ): zio.aws.auditmanager.model.RegisterAccountResponse.ReadOnly = new Wrapper(
    impl
  )
}
