package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.S3Url
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DefaultExportDestination(
    destinationType: Optional[
      zio.aws.auditmanager.model.ExportDestinationType
    ] = Optional.Absent,
    destination: Optional[S3Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DefaultExportDestination = {
    import DefaultExportDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DefaultExportDestination
      .builder()
      .optionallyWith(destinationType.map(value => value.unwrap))(
        _.destinationType
      )
      .optionallyWith(
        destination.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.destination)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.DefaultExportDestination.ReadOnly =
    zio.aws.auditmanager.model.DefaultExportDestination.wrap(buildAwsValue())
}
object DefaultExportDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DefaultExportDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.DefaultExportDestination =
      zio.aws.auditmanager.model.DefaultExportDestination(
        destinationType.map(value => value),
        destination.map(value => value)
      )
    def destinationType
        : Optional[zio.aws.auditmanager.model.ExportDestinationType]
    def destination: Optional[S3Url]
    def getDestinationType
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ExportDestinationType] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getDestination: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DefaultExportDestination
  ) extends zio.aws.auditmanager.model.DefaultExportDestination.ReadOnly {
    override val destinationType
        : Optional[zio.aws.auditmanager.model.ExportDestinationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationType())
        .map(value =>
          zio.aws.auditmanager.model.ExportDestinationType.wrap(value)
        )
    override val destination: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.auditmanager.model.primitives.S3Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DefaultExportDestination
  ): zio.aws.auditmanager.model.DefaultExportDestination.ReadOnly = new Wrapper(
    impl
  )
}
