package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  AuditManagerArn,
  Timestamp,
  UUID,
  ControlSources,
  ControlName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ControlMetadata(
    arn: Optional[AuditManagerArn] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    name: Optional[ControlName] = Optional.Absent,
    controlSources: Optional[ControlSources] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ControlMetadata = {
    import ControlMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ControlMetadata
      .builder()
      .optionallyWith(
        arn.map(value => AuditManagerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ControlName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        controlSources.map(value =>
          ControlSources.unwrap(value): java.lang.String
        )
      )(_.controlSources)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ControlMetadata.ReadOnly =
    zio.aws.auditmanager.model.ControlMetadata.wrap(buildAwsValue())
}
object ControlMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ControlMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ControlMetadata =
      zio.aws.auditmanager.model.ControlMetadata(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        controlSources.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def arn: Optional[AuditManagerArn]
    def id: Optional[UUID]
    def name: Optional[ControlName]
    def controlSources: Optional[ControlSources]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def getArn: ZIO[Any, AwsError, AuditManagerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ControlName] =
      AwsError.unwrapOptionField("name", name)
    def getControlSources: ZIO[Any, AwsError, ControlSources] =
      AwsError.unwrapOptionField("controlSources", controlSources)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlMetadata
  ) extends zio.aws.auditmanager.model.ControlMetadata.ReadOnly {
    override val arn: Optional[AuditManagerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AuditManagerArn(value)
      )
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val name: Optional[ControlName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.ControlName(value))
    override val controlSources: Optional[ControlSources] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlSources())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ControlSources(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlMetadata
  ): zio.aws.auditmanager.model.ControlMetadata.ReadOnly = new Wrapper(impl)
}
