package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{Timestamp, UUID, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ControlInsightsMetadataItem(
    name: Optional[NonEmptyString] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    evidenceInsights: Optional[zio.aws.auditmanager.model.EvidenceInsights] =
      Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem = {
    import ControlInsightsMetadataItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(evidenceInsights.map(value => value.buildAwsValue()))(
        _.evidenceInsights
      )
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ControlInsightsMetadataItem.ReadOnly =
    zio.aws.auditmanager.model.ControlInsightsMetadataItem.wrap(buildAwsValue())
}
object ControlInsightsMetadataItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ControlInsightsMetadataItem =
      zio.aws.auditmanager.model.ControlInsightsMetadataItem(
        name.map(value => value),
        id.map(value => value),
        evidenceInsights.map(value => value.asEditable),
        lastUpdated.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def id: Optional[UUID]
    def evidenceInsights
        : Optional[zio.aws.auditmanager.model.EvidenceInsights.ReadOnly]
    def lastUpdated: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getEvidenceInsights: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.EvidenceInsights.ReadOnly
    ] = AwsError.unwrapOptionField("evidenceInsights", evidenceInsights)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem
  ) extends zio.aws.auditmanager.model.ControlInsightsMetadataItem.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val evidenceInsights
        : Optional[zio.aws.auditmanager.model.EvidenceInsights.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceInsights())
        .map(value => zio.aws.auditmanager.model.EvidenceInsights.wrap(value))
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem
  ): zio.aws.auditmanager.model.ControlInsightsMetadataItem.ReadOnly =
    new Wrapper(impl)
}
