package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{ErrorMessage, ErrorCode, UUID}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDeleteDelegationByAssessmentError(
    delegationId: Optional[UUID] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError = {
    import BatchDeleteDelegationByAssessmentError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError
      .builder()
      .optionallyWith(
        delegationId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.delegationId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError.ReadOnly =
    zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError
      .wrap(buildAwsValue())
}
object BatchDeleteDelegationByAssessmentError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError =
      zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError(
        delegationId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def delegationId: Optional[UUID]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getDelegationId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("delegationId", delegationId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError
  ) extends zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError.ReadOnly {
    override val delegationId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.delegationId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError
  ): zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError.ReadOnly =
    new Wrapper(impl)
}
