package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class BatchCreateDelegationByAssessmentRequest(
    createDelegationRequests: Iterable[
      zio.aws.auditmanager.model.CreateDelegationRequest
    ],
    assessmentId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest = {
    import BatchCreateDelegationByAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest
      .builder()
      .createDelegationRequests(createDelegationRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentRequest.ReadOnly =
    zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentRequest
      .wrap(buildAwsValue())
}
object BatchCreateDelegationByAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentRequest =
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentRequest(
        createDelegationRequests.map { item =>
          item.asEditable
        },
        assessmentId
      )
    def createDelegationRequests
        : List[zio.aws.auditmanager.model.CreateDelegationRequest.ReadOnly]
    def assessmentId: UUID
    def getCreateDelegationRequests: ZIO[Any, Nothing, List[
      zio.aws.auditmanager.model.CreateDelegationRequest.ReadOnly
    ]] = ZIO.succeed(createDelegationRequests)
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest
  ) extends zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentRequest.ReadOnly {
    override val createDelegationRequests
        : List[zio.aws.auditmanager.model.CreateDelegationRequest.ReadOnly] =
      impl
        .createDelegationRequests()
        .asScala
        .map { item =>
          zio.aws.auditmanager.model.CreateDelegationRequest.wrap(item)
        }
        .toList
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest
  ): zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentRequest.ReadOnly =
    new Wrapper(impl)
}
