package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  FrameworkName,
  AccountId,
  Timestamp,
  ShareRequestComment,
  FrameworkDescription,
  ComplianceType,
  UUID,
  Region,
  NullableInteger
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AssessmentFrameworkShareRequest(
    id: Optional[UUID] = Optional.Absent,
    frameworkId: Optional[UUID] = Optional.Absent,
    frameworkName: Optional[FrameworkName] = Optional.Absent,
    frameworkDescription: Optional[FrameworkDescription] = Optional.Absent,
    status: Optional[zio.aws.auditmanager.model.ShareRequestStatus] =
      Optional.Absent,
    sourceAccount: Optional[AccountId] = Optional.Absent,
    destinationAccount: Optional[AccountId] = Optional.Absent,
    destinationRegion: Optional[Region] = Optional.Absent,
    expirationTime: Optional[Timestamp] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent,
    comment: Optional[ShareRequestComment] = Optional.Absent,
    standardControlsCount: Optional[NullableInteger] = Optional.Absent,
    customControlsCount: Optional[NullableInteger] = Optional.Absent,
    complianceType: Optional[ComplianceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest = {
    import AssessmentFrameworkShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        frameworkId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.frameworkId)
      .optionallyWith(
        frameworkName.map(value =>
          FrameworkName.unwrap(value): java.lang.String
        )
      )(_.frameworkName)
      .optionallyWith(
        frameworkDescription.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.frameworkDescription)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sourceAccount.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.sourceAccount)
      .optionallyWith(
        destinationAccount.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.destinationAccount)
      .optionallyWith(
        destinationRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.destinationRegion)
      .optionallyWith(
        expirationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationTime)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        comment.map(value =>
          ShareRequestComment.unwrap(value): java.lang.String
        )
      )(_.comment)
      .optionallyWith(standardControlsCount.map(value => value: Integer))(
        _.standardControlsCount
      )
      .optionallyWith(customControlsCount.map(value => value: Integer))(
        _.customControlsCount
      )
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly =
    zio.aws.auditmanager.model.AssessmentFrameworkShareRequest
      .wrap(buildAwsValue())
}
object AssessmentFrameworkShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentFrameworkShareRequest =
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest(
        id.map(value => value),
        frameworkId.map(value => value),
        frameworkName.map(value => value),
        frameworkDescription.map(value => value),
        status.map(value => value),
        sourceAccount.map(value => value),
        destinationAccount.map(value => value),
        destinationRegion.map(value => value),
        expirationTime.map(value => value),
        creationTime.map(value => value),
        lastUpdated.map(value => value),
        comment.map(value => value),
        standardControlsCount.map(value => value),
        customControlsCount.map(value => value),
        complianceType.map(value => value)
      )
    def id: Optional[UUID]
    def frameworkId: Optional[UUID]
    def frameworkName: Optional[FrameworkName]
    def frameworkDescription: Optional[FrameworkDescription]
    def status: Optional[zio.aws.auditmanager.model.ShareRequestStatus]
    def sourceAccount: Optional[AccountId]
    def destinationAccount: Optional[AccountId]
    def destinationRegion: Optional[Region]
    def expirationTime: Optional[Timestamp]
    def creationTime: Optional[Timestamp]
    def lastUpdated: Optional[Timestamp]
    def comment: Optional[ShareRequestComment]
    def standardControlsCount: Optional[NullableInteger]
    def customControlsCount: Optional[NullableInteger]
    def complianceType: Optional[ComplianceType]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getFrameworkId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("frameworkId", frameworkId)
    def getFrameworkName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("frameworkName", frameworkName)
    def getFrameworkDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("frameworkDescription", frameworkDescription)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ShareRequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSourceAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("sourceAccount", sourceAccount)
    def getDestinationAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("destinationAccount", destinationAccount)
    def getDestinationRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("destinationRegion", destinationRegion)
    def getExpirationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getComment: ZIO[Any, AwsError, ShareRequestComment] =
      AwsError.unwrapOptionField("comment", comment)
    def getStandardControlsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("standardControlsCount", standardControlsCount)
    def getCustomControlsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("customControlsCount", customControlsCount)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest
  ) extends zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val frameworkId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val frameworkName: Optional[FrameworkName] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkName())
      .map(value => zio.aws.auditmanager.model.primitives.FrameworkName(value))
    override val frameworkDescription: Optional[FrameworkDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkDescription())
        .map(value =>
          zio.aws.auditmanager.model.primitives.FrameworkDescription(value)
        )
    override val status
        : Optional[zio.aws.auditmanager.model.ShareRequestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.auditmanager.model.ShareRequestStatus.wrap(value))
    override val sourceAccount: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAccount())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val destinationAccount: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationAccount())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val destinationRegion: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationRegion())
      .map(value => zio.aws.auditmanager.model.primitives.Region(value))
    override val expirationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val comment: Optional[ShareRequestComment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ShareRequestComment(value)
      )
    override val standardControlsCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardControlsCount())
        .map(value => value: NullableInteger)
    override val customControlsCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customControlsCount())
        .map(value => value: NullableInteger)
    override val complianceType: Optional[ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ComplianceType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest
  ): zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly =
    new Wrapper(impl)
}
