package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  ControlSetId,
  AssessmentEvidenceFolderName,
  Timestamp,
  Integer,
  UUID,
  ControlName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AssessmentEvidenceFolder(
    name: Optional[AssessmentEvidenceFolderName] = Optional.Absent,
    date: Optional[Timestamp] = Optional.Absent,
    assessmentId: Optional[UUID] = Optional.Absent,
    controlSetId: Optional[ControlSetId] = Optional.Absent,
    controlId: Optional[UUID] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    dataSource: Optional[String] = Optional.Absent,
    author: Optional[String] = Optional.Absent,
    totalEvidence: Optional[Integer] = Optional.Absent,
    assessmentReportSelectionCount: Optional[Integer] = Optional.Absent,
    controlName: Optional[ControlName] = Optional.Absent,
    evidenceResourcesIncludedCount: Optional[Integer] = Optional.Absent,
    evidenceByTypeConfigurationDataCount: Optional[Integer] = Optional.Absent,
    evidenceByTypeManualCount: Optional[Integer] = Optional.Absent,
    evidenceByTypeComplianceCheckCount: Optional[Integer] = Optional.Absent,
    evidenceByTypeComplianceCheckIssuesCount: Optional[Integer] =
      Optional.Absent,
    evidenceByTypeUserActivityCount: Optional[Integer] = Optional.Absent,
    evidenceAwsServiceSourceCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder = {
    import AssessmentEvidenceFolder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder
      .builder()
      .optionallyWith(
        name.map(value =>
          AssessmentEvidenceFolderName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(date.map(value => Timestamp.unwrap(value): Instant))(
        _.date
      )
      .optionallyWith(
        assessmentId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.assessmentId)
      .optionallyWith(
        controlSetId.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.controlSetId)
      .optionallyWith(
        controlId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.controlId)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(dataSource.map(value => value: java.lang.String))(
        _.dataSource
      )
      .optionallyWith(author.map(value => value: java.lang.String))(_.author)
      .optionallyWith(totalEvidence.map(value => value: java.lang.Integer))(
        _.totalEvidence
      )
      .optionallyWith(
        assessmentReportSelectionCount.map(value => value: java.lang.Integer)
      )(_.assessmentReportSelectionCount)
      .optionallyWith(
        controlName.map(value => ControlName.unwrap(value): java.lang.String)
      )(_.controlName)
      .optionallyWith(
        evidenceResourcesIncludedCount.map(value => value: java.lang.Integer)
      )(_.evidenceResourcesIncludedCount)
      .optionallyWith(
        evidenceByTypeConfigurationDataCount.map(value =>
          value: java.lang.Integer
        )
      )(_.evidenceByTypeConfigurationDataCount)
      .optionallyWith(
        evidenceByTypeManualCount.map(value => value: java.lang.Integer)
      )(_.evidenceByTypeManualCount)
      .optionallyWith(
        evidenceByTypeComplianceCheckCount.map(value =>
          value: java.lang.Integer
        )
      )(_.evidenceByTypeComplianceCheckCount)
      .optionallyWith(
        evidenceByTypeComplianceCheckIssuesCount.map(value =>
          value: java.lang.Integer
        )
      )(_.evidenceByTypeComplianceCheckIssuesCount)
      .optionallyWith(
        evidenceByTypeUserActivityCount.map(value => value: java.lang.Integer)
      )(_.evidenceByTypeUserActivityCount)
      .optionallyWith(
        evidenceAwsServiceSourceCount.map(value => value: java.lang.Integer)
      )(_.evidenceAwsServiceSourceCount)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly =
    zio.aws.auditmanager.model.AssessmentEvidenceFolder.wrap(buildAwsValue())
}
object AssessmentEvidenceFolder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentEvidenceFolder =
      zio.aws.auditmanager.model.AssessmentEvidenceFolder(
        name.map(value => value),
        date.map(value => value),
        assessmentId.map(value => value),
        controlSetId.map(value => value),
        controlId.map(value => value),
        id.map(value => value),
        dataSource.map(value => value),
        author.map(value => value),
        totalEvidence.map(value => value),
        assessmentReportSelectionCount.map(value => value),
        controlName.map(value => value),
        evidenceResourcesIncludedCount.map(value => value),
        evidenceByTypeConfigurationDataCount.map(value => value),
        evidenceByTypeManualCount.map(value => value),
        evidenceByTypeComplianceCheckCount.map(value => value),
        evidenceByTypeComplianceCheckIssuesCount.map(value => value),
        evidenceByTypeUserActivityCount.map(value => value),
        evidenceAwsServiceSourceCount.map(value => value)
      )
    def name: Optional[AssessmentEvidenceFolderName]
    def date: Optional[Timestamp]
    def assessmentId: Optional[UUID]
    def controlSetId: Optional[ControlSetId]
    def controlId: Optional[UUID]
    def id: Optional[UUID]
    def dataSource: Optional[String]
    def author: Optional[String]
    def totalEvidence: Optional[Integer]
    def assessmentReportSelectionCount: Optional[Integer]
    def controlName: Optional[ControlName]
    def evidenceResourcesIncludedCount: Optional[Integer]
    def evidenceByTypeConfigurationDataCount: Optional[Integer]
    def evidenceByTypeManualCount: Optional[Integer]
    def evidenceByTypeComplianceCheckCount: Optional[Integer]
    def evidenceByTypeComplianceCheckIssuesCount: Optional[Integer]
    def evidenceByTypeUserActivityCount: Optional[Integer]
    def evidenceAwsServiceSourceCount: Optional[Integer]
    def getName: ZIO[Any, AwsError, AssessmentEvidenceFolderName] =
      AwsError.unwrapOptionField("name", name)
    def getDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("date", date)
    def getAssessmentId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("assessmentId", assessmentId)
    def getControlSetId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("controlSetId", controlSetId)
    def getControlId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("controlId", controlId)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getAuthor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("author", author)
    def getTotalEvidence: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalEvidence", totalEvidence)
    def getAssessmentReportSelectionCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "assessmentReportSelectionCount",
        assessmentReportSelectionCount
      )
    def getControlName: ZIO[Any, AwsError, ControlName] =
      AwsError.unwrapOptionField("controlName", controlName)
    def getEvidenceResourcesIncludedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceResourcesIncludedCount",
        evidenceResourcesIncludedCount
      )
    def getEvidenceByTypeConfigurationDataCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceByTypeConfigurationDataCount",
        evidenceByTypeConfigurationDataCount
      )
    def getEvidenceByTypeManualCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("evidenceByTypeManualCount", evidenceByTypeManualCount)
    def getEvidenceByTypeComplianceCheckCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceByTypeComplianceCheckCount",
        evidenceByTypeComplianceCheckCount
      )
    def getEvidenceByTypeComplianceCheckIssuesCount
        : ZIO[Any, AwsError, Integer] = AwsError.unwrapOptionField(
      "evidenceByTypeComplianceCheckIssuesCount",
      evidenceByTypeComplianceCheckIssuesCount
    )
    def getEvidenceByTypeUserActivityCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceByTypeUserActivityCount",
        evidenceByTypeUserActivityCount
      )
    def getEvidenceAwsServiceSourceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceAwsServiceSourceCount",
        evidenceAwsServiceSourceCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder
  ) extends zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly {
    override val name: Optional[AssessmentEvidenceFolderName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.auditmanager.model.primitives
            .AssessmentEvidenceFolderName(value)
        )
    override val date: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val assessmentId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val controlSetId: Optional[ControlSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.controlSetId())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val controlId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.controlId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val dataSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSource())
      .map(value => value: String)
    override val author: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.author())
      .map(value => value: String)
    override val totalEvidence: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalEvidence())
      .map(value => value: Integer)
    override val assessmentReportSelectionCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessmentReportSelectionCount())
        .map(value => value: Integer)
    override val controlName: Optional[ControlName] = zio.aws.core.internal
      .optionalFromNullable(impl.controlName())
      .map(value => zio.aws.auditmanager.model.primitives.ControlName(value))
    override val evidenceResourcesIncludedCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceResourcesIncludedCount())
        .map(value => value: Integer)
    override val evidenceByTypeConfigurationDataCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceByTypeConfigurationDataCount())
        .map(value => value: Integer)
    override val evidenceByTypeManualCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceByTypeManualCount())
        .map(value => value: Integer)
    override val evidenceByTypeComplianceCheckCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceByTypeComplianceCheckCount())
        .map(value => value: Integer)
    override val evidenceByTypeComplianceCheckIssuesCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceByTypeComplianceCheckIssuesCount())
        .map(value => value: Integer)
    override val evidenceByTypeUserActivityCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceByTypeUserActivityCount())
        .map(value => value: Integer)
    override val evidenceAwsServiceSourceCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceAwsServiceSourceCount())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder
  ): zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly = new Wrapper(
    impl
  )
}
