package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait ExportDestinationType {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.ExportDestinationType
}
object ExportDestinationType {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ExportDestinationType
  ): zio.aws.auditmanager.model.ExportDestinationType = value match {
    case software.amazon.awssdk.services.auditmanager.model.ExportDestinationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ExportDestinationType.S3 =>
      val r = S3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ExportDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ExportDestinationType =
      software.amazon.awssdk.services.auditmanager.model.ExportDestinationType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.auditmanager.model.ExportDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ExportDestinationType =
      software.amazon.awssdk.services.auditmanager.model.ExportDestinationType.S3
  }
}
