package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEvidenceFolderResponse(
    evidenceFolder: Optional[
      zio.aws.auditmanager.model.AssessmentEvidenceFolder
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderResponse = {
    import GetEvidenceFolderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderResponse
      .builder()
      .optionallyWith(evidenceFolder.map(value => value.buildAwsValue()))(
        _.evidenceFolder
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceFolderResponse.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceFolderResponse.wrap(buildAwsValue())
}
object GetEvidenceFolderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetEvidenceFolderResponse =
      zio.aws.auditmanager.model.GetEvidenceFolderResponse(
        evidenceFolder.map(value => value.asEditable)
      )
    def evidenceFolder
        : Optional[zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly]
    def getEvidenceFolder: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly
    ] = AwsError.unwrapOptionField("evidenceFolder", evidenceFolder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderResponse
  ) extends zio.aws.auditmanager.model.GetEvidenceFolderResponse.ReadOnly {
    override val evidenceFolder: Optional[
      zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.evidenceFolder())
      .map(value =>
        zio.aws.auditmanager.model.AssessmentEvidenceFolder.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderResponse
  ): zio.aws.auditmanager.model.GetEvidenceFolderResponse.ReadOnly =
    new Wrapper(impl)
}
