package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetChangeLogsResponse(
    changeLogs: Optional[Iterable[zio.aws.auditmanager.model.ChangeLog]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse = {
    import GetChangeLogsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse
      .builder()
      .optionallyWith(
        changeLogs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changeLogs)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetChangeLogsResponse.ReadOnly =
    zio.aws.auditmanager.model.GetChangeLogsResponse.wrap(buildAwsValue())
}
object GetChangeLogsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetChangeLogsResponse =
      zio.aws.auditmanager.model.GetChangeLogsResponse(
        changeLogs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def changeLogs
        : Optional[List[zio.aws.auditmanager.model.ChangeLog.ReadOnly]]
    def nextToken: Optional[Token]
    def getChangeLogs: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ChangeLog.ReadOnly
    ]] = AwsError.unwrapOptionField("changeLogs", changeLogs)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse
  ) extends zio.aws.auditmanager.model.GetChangeLogsResponse.ReadOnly {
    override val changeLogs
        : Optional[List[zio.aws.auditmanager.model.ChangeLog.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeLogs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.ChangeLog.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse
  ): zio.aws.auditmanager.model.GetChangeLogsResponse.ReadOnly = new Wrapper(
    impl
  )
}
