package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class DeleteControlRequest(controlId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest = {
    import DeleteControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest
      .builder()
      .controlId(UUID.unwrap(controlId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.DeleteControlRequest.ReadOnly =
    zio.aws.auditmanager.model.DeleteControlRequest.wrap(buildAwsValue())
}
object DeleteControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.DeleteControlRequest =
      zio.aws.auditmanager.model.DeleteControlRequest(controlId)
    def controlId: UUID
    def getControlId: ZIO[Any, Nothing, UUID] = ZIO.succeed(controlId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest
  ) extends zio.aws.auditmanager.model.DeleteControlRequest.ReadOnly {
    override val controlId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.controlId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest
  ): zio.aws.auditmanager.model.DeleteControlRequest.ReadOnly = new Wrapper(
    impl
  )
}
