package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait KeywordInputType {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.KeywordInputType
}
object KeywordInputType {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.KeywordInputType
  ): zio.aws.auditmanager.model.KeywordInputType = value match {
    case software.amazon.awssdk.services.auditmanager.model.KeywordInputType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.KeywordInputType.SELECT_FROM_LIST =>
      val r = SELECT_FROM_LIST
      r
    case software.amazon.awssdk.services.auditmanager.model.KeywordInputType.UPLOAD_FILE =>
      val r = UPLOAD_FILE
      r
    case software.amazon.awssdk.services.auditmanager.model.KeywordInputType.INPUT_TEXT =>
      val r = INPUT_TEXT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.KeywordInputType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.KeywordInputType =
      software.amazon.awssdk.services.auditmanager.model.KeywordInputType.UNKNOWN_TO_SDK_VERSION
  }
  case object SELECT_FROM_LIST
      extends zio.aws.auditmanager.model.KeywordInputType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.KeywordInputType =
      software.amazon.awssdk.services.auditmanager.model.KeywordInputType.SELECT_FROM_LIST
  }
  case object UPLOAD_FILE extends zio.aws.auditmanager.model.KeywordInputType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.KeywordInputType =
      software.amazon.awssdk.services.auditmanager.model.KeywordInputType.UPLOAD_FILE
  }
  case object INPUT_TEXT extends zio.aws.auditmanager.model.KeywordInputType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.KeywordInputType =
      software.amazon.awssdk.services.auditmanager.model.KeywordInputType.INPUT_TEXT
  }
}
