package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait AssessmentReportStatus {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus
}
object AssessmentReportStatus {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus
  ): zio.aws.auditmanager.model.AssessmentReportStatus = value match {
    case software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.AssessmentReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus =
      software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETE
      extends zio.aws.auditmanager.model.AssessmentReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus =
      software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus.COMPLETE
  }
  case object IN_PROGRESS
      extends zio.aws.auditmanager.model.AssessmentReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus =
      software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.auditmanager.model.AssessmentReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus =
      software.amazon.awssdk.services.auditmanager.model.AssessmentReportStatus.FAILED
  }
}
